@extends('panel.layout.app')
@section('title', $openai->title)

@section('content')
    <div class="page-header">
        <div class="container-xl">
            <div class="row g-2 items-center">
                <div class="col">
                    <div class="page-pretitle">
                        {{__($openai->description)}}
                    </div>
                    <h2 class="page-title mb-2">
                        {{__($openai->title)}}
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <!-- Page body -->
    <div class="page-body page-generator pt-6">
        <div class="container-xl">
            @if($openai->type == 'image')
                @include('panel.user.openai.generator_components.generator_image')
            @elseif($openai->type == 'voiceover')
                @include('panel.user.openai.generator_components.generator_voiceover')
            @else
                @include('panel.user.openai.generator_components.generator_others')
            @endif
        </div>
    </div>
@endsection
@section('script')
    <script src="/assets/libs/tom-select/dist/js/tom-select.base.min.js?1674944402" defer></script>
    <script src="/assets/js/panel/openai_generator.js"></script>
    <script src="/assets/libs/fslightbox/index.js?1674944402" defer></script>
    <script src="/assets/libs/wavesurfer/wavesurfer.js"></script>
    <script src="/assets/js/panel/voiceover.js"></script>

    @if($openai->type == 'voiceover')

        <script>

            function generateSpeech() {
                "use strict";

                document.getElementById( "generate_speech_button" ).disabled = true;
                document.getElementById( "generate_speech_button" ).innerHTML = magicai_localize.please_wait;

                var formData = new FormData();
                var speechData = [];
                formData.append( 'workbook_title', $('#workbook_title').val() );

                $('.speeches .speech').each(function() {
                    var data = {
                        voice:   $(this).find('textarea').attr('data-voice'),
                        lang:    $(this).find('textarea').attr('data-lang'),
                        pace:    $(this).find('textarea').attr('data-pace'),
                        break:   $(this).find('textarea').attr('data-break'),
                        content: $(this).find('textarea').val()
                    };
                    speechData.push(data);
                });

                var jsonData = JSON.stringify(speechData);
                formData.append( 'speeches', jsonData );

                $.ajax( {
                    type: "post",
                        headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}",
                    },
                    url: "/dashboard/user/openai/generate-speech",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function ( data ) {
                        toastr.success( data.message );
                        document.getElementById( "generate_speech_button" ).disabled = false;
                        document.getElementById( "generate_speech_button" ).innerHTML = "Generate";
                        $("#generator_sidebar_table").html(data.html2);

						var audioElements = document.querySelectorAll('.data-audio');
						audioElements.forEach( generateWaveForm );
                    },
                    error: function ( data ) {
                        var err = data.responseJSON.errors;
                        $.each( err, function ( index, value ) {
                            toastr.error( value );
                        } );
                        document.getElementById( "generate_speech_button" ).disabled = false;
                        document.getElementById( "generate_speech_button" ).innerHTML = "Save";
                    }
                } );
                return false;
            }

            const voicesData = {
                "af-ZA": [
                    {value:"af-ZA-Standard-A", label: "Ayanda (Female)"}
                ],
                "ar-XA": [
                    {value:"ar-XA-Standard-A", label: "Fatima (Female)"},
                    {value:"ar-XA-Standard-B", label: "Ahmed (Male)"},
                    {value:"ar-XA-Standard-C", label: "Mohammed (Male)"},
                    {value:"ar-XA-Standard-D", label: "Aisha (Female)"},
                    {value:"ar-XA-Wavenet-A", label: "Layla (Female)"},
                    {value:"ar-XA-Wavenet-B", label: "Ali (Male)"},
                    {value:"ar-XA-Wavenet-C", label: "Omar (Male)"},
                    {value:"ar-XA-Wavenet-D", label: "Zahra (Female)"}
                ],
                "eu-ES": [
                    {value:"eu-ES-Standard-A", label: "Ane (Female)"}
                ],
                "bn-IN": [
                    {value:"bn-IN-Standard-A", label: "Ananya (Female)"},
                    {value:"bn-IN-Standard-B", label: "Aryan (Male)"},
                    {value:"bn-IN-Wavenet-A", label: "Ishita (Female)"},
                    {value:"bn-IN-Wavenet-B", label: "Arry (Male)"}
                ],
                "bg-BG": [
                    {value:"bg-BG-Standard-A", label: "Elena (Female)"}
                ],
                "ca-ES": [
                    {value:"ca-ES-Standard-A", label: "Laia (Female)"}
                ],
                "yue-HK": [
                    {value:"yue-HK-Standard-A", label: "Wing (Female)"},
                    {value:"yue-HK-Standard-B", label: "Ho (Male)"},
                    {value:"yue-HK-Standard-C", label: "Siu (Female)"},
                    {value:"yue-HK-Standard-D", label: "Lau (Male)"}
                ],
                "cs-CZ": [
                    {value:"cs-CZ-Standard-A", label: "Tereza (Female)"},
                    {value:"cs-CZ-Wavenet-A", label: "Karolína (Female)"}
                ],
                "da-DK": [
                    //{value:"da-DK-Neural2-D", label: "Neural2 - FEMALE"},
                    //{value:"da-DK-Neural2-F", label: "Neural2 - MALE"},
                    {value:"da-DK-Standard-A", label: "Emma (Female)"},
                    {value:"da-DK-Standard-A", label: "Freja (Female)"},
                    {value:"da-DK-Standard-A", label: "Ida (Female)"},
                    {value:"da-DK-Standard-C", label: "Noah (Male)"},
                    {value:"da-DK-Standard-D", label: "Mathilde (Female)"},
                    {value:"da-DK-Standard-E", label: "Clara (Female)"},
                    {value:"da-DK-Wavenet-A", label: "Isabella (Female)"},
                    {value:"da-DK-Wavenet-C", label: "Lucas (Male)"},
                    {value:"da-DK-Wavenet-D", label: "Olivia (Female)"},
                    {value:"da-DK-Wavenet-E", label: "Emily (Female)"}
                ],
                "nl-BE": [
                    {value:"nl-BE-Standard-A", label: "Emma (Female)"},
                    {value:"nl-BE-Standard-B", label: "Thomas (Male)"},
                    {value:"nl-BE-Wavenet-A", label: "Sophie (Female)"},
                    {value:"nl-BE-Wavenet-B", label: "Lucas (Male)"}
                ],
                "nl-NL": [
                    {value:"nl-NL-Standard-A", label: "Emma (Female)"},
                    {value:"nl-NL-Standard-B", label: "Daan (Male)"},
                    {value:"nl-NL-Standard-C", label: "Luuk (Male)"},
                    {value:"nl-NL-Standard-D", label: "Lotte (Female)"},
                    {value:"nl-NL-Standard-E", label: "Sophie (Female)"},
                    {value:"nl-NL-Wavenet-A", label: "Mila (Female)"},
                    {value:"nl-NL-Wavenet-B", label: "Sem (Male)"},
                    {value:"nl-NL-Wavenet-C", label: "Stijn (Male)"},
                    {value:"nl-NL-Wavenet-D", label: "Fenna (Female)"},
                    {value:"nl-NL-Wavenet-E", label: "Eva (Female)"}
                ],
                "en-AU": [
                    //{value:"en-AU-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"en-AU-Neural2-B", label: "Neural2 - MALE"},
                    //{value:"en-AU-Neural2-C", label: "Neural2 - FEMALE"},
                    //{value:"en-AU-Neural2-D", label: "Neural2 - MALE"},
                    {value:"en-AU-News-E", label: "Emma (Female)"},
                    {value:"en-AU-News-F", label: "Olivia (Female)"},
                    {value:"en-AU-News-G", label: "Liam (Male)"},
                    //{value:"en-AU-Polyglot-1", label: "Noah (Male)"},
                    {value:"en-AU-Standard-A", label: "Charlotte (Female)"},
                    {value:"en-AU-Standard-B", label: "Oliver (Male)"},
                    {value:"en-AU-Standard-C", label: "Ava (Female)"},
                    {value:"en-AU-Standard-D", label: "Jack (Male)"},
                    {value:"en-AU-Wavenet-A", label: "Sophie (Female)"},
                    {value:"en-AU-Wavenet-B", label: "William (Male)"},
                    {value:"en-AU-Wavenet-C", label: "Amelia (Female)"},
                    {value:"en-AU-Wavenet-D", label: "Thomas (Male)"}
                ],
                "en-IN": [
                    {value: "en-IN-Standard-A", label: "Aditi (Female)"},
                    {value: "en-IN-Standard-B", label: "Arjun (Male)"},
                    {value: "en-IN-Standard-C", label: "Rohan (Male)"},
                    {value: "en-IN-Standard-D", label: "Ananya (Female)"},
                    {value: "en-IN-Wavenet-A", label: "Alisha (Female)"},
                    {value: "en-IN-Wavenet-B", label: "Aryan (Male)"},
                    {value: "en-IN-Wavenet-C", label: "Kabir (Male)"},
                    {value: "en-IN-Wavenet-D", label: "Diya (Female)"}
                ],
                "en-GB": [
                    //{value:"en-GB-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"en-GB-Neural2-B", label: "Neural2 - MALE"},
                    //{value:"en-GB-Neural2-C", label: "Neural2 - FEMALE"},
                    //{value:"en-GB-Neural2-D", label: "Neural2 - MALE"},
                    //{value:"en-GB-Neural2-F", label: "Neural2 - FEMALE"},
                    {value:"en-GB-News-G", label:"Amelia (Female)"},
                    {value:"en-GB-News-H", label:"Elise (Female)"},
                    {value:"en-GB-News-I", label:"Isabella (Female)"},
                    {value:"en-GB-News-J", label:"Jessica (Female)"},
                    {value:"en-GB-News-K", label:"Alexander (Male)"},
                    {value:"en-GB-News-L", label:"Benjamin (Male)"},
                    {value:"en-GB-News-M", label:"Charles (Male)"},
                    {value:"en-GB-Standard-A", label:"Emily (Female)"},
                    {value:"en-GB-Standard-B", label:"John (Male)"},
                    {value:"en-GB-Standard-C", label:"Mary (Female)"},
                    {value:"en-GB-Standard-D", label:"Peter (Male)"},
                    {value:"en-GB-Standard-F", label:"Sarah (Female)"},
                    {value:"en-GB-Wavenet-A", label:"Ava (Female)"},
                    {value:"en-GB-Wavenet-B", label:"David (Male)"},
                    {value:"en-GB-Wavenet-C", label:"Emily (Female)"},
                    {value:"en-GB-Wavenet-D", label:"James (Male)"},
                    {value:"en-GB-Wavenet-F", label:"Sophie (Female)"}
                ],
                "en-US": [
                    //{value:"en-US-Neural2-A", label: "Neural2 - MALE"},
                    //{value:"en-US-Neural2-C", label: "Neural2 - FEMALE"},
                    //{value:"en-US-Neural2-D", label: "Neural2 - MALE"},
                    //{value:"en-US-Neural2-E", label: "Neural2 - FEMALE"},
                    //{value:"en-US-Neural2-F", label: "Neural2 - FEMALE"},
                    //{value:"en-US-Neural2-G", label: "Neural2 - FEMALE"},
                    //{value:"en-US-Neural2-H", label: "Neural2 - FEMALE"},
                    //{value:"en-US-Neural2-I", label: "Neural2 - MALE"},
                    //{value:"en-US-Neural2-J", label: "Neural2 - MALE"},
                    {value:"en-US-News-K", label:"Lily (Female)"},
                    {value:"en-US-News-L", label:"Olivia (Female)"},
                    {value:"en-US-News-M", label:"Noah (Male)"},
                    {value:"en-US-News-N", label:"Oliver (Male)"},
                    //{value:"en-US-Polyglot-1", label:"John (Male)"},
                    {value:"en-US-Standard-A", label:"Michael (Male)"},
                    {value:"en-US-Standard-B", label:"David (Male)"},
                    {value:"en-US-Standard-C", label:"Emma (Female)"},
                    {value:"en-US-Standard-D", label:"William (Male)"},
                    {value:"en-US-Standard-E", label:"Ava (Female)"},
                    {value:"en-US-Standard-F", label:"Sophia (Female)"},
                    {value:"en-US-Standard-G", label:"Isabella (Female)"},
                    {value:"en-US-Standard-H", label:"Charlotte (Female)"},
                    {value:"en-US-Standard-I", label:"James (Male)"},
                    {value:"en-US-Standard-J", label:"Lucas (Male)"},
                    {value:"en-US-Studio-M", label:"Benjamin (Male)"},
                    {value:"en-US-Studio-O", label:"Eleanor (Female)"},
                    {value:"en-US-Wavenet-A", label:"Alexander (Male)"},
                    {value:"en-US-Wavenet-B", label:"Benjamin (Male)"},
                    {value:"en-US-Wavenet-C", label:"Emily (Female)"},
                    {value:"en-US-Wavenet-D", label:"James (Male)"},
                    {value:"en-US-Wavenet-E", label:"Ava (Female)"},
                    {value:"en-US-Wavenet-F", label:"Sophia (Female)"},
                    {value:"en-US-Wavenet-G", label:"Isabella (Female)"},
                    {value:"en-US-Wavenet-H", label:"Charlotte (Female)"},
                    {value:"en-US-Wavenet-I", label:"Alexander (Male)"},
                    {value:"en-US-Wavenet-J", label:"Lucas (Male)"}
                ],
                "fil-PH": [
                    {value:"fil-PH-Standard-A", label:"Maria (Female)"},
                    {value:"fil-PH-Standard-B", label:"Juana (Female)"},
                    {value:"fil-PH-Standard-C", label:"Juan (Male)"},
                    {value:"fil-PH-Standard-D", label:"Pedro (Male)"},
                    {value:"fil-PH-Wavenet-A", label:"Maria (Female)"},
                    {value:"fil-PH-Wavenet-B", label:"Juana (Female)"},
                    {value:"fil-PH-Wavenet-C", label:"Juan (Male)"},
                    {value:"fil-PH-Wavenet-D", label:"Pedro (Male)"}
                    //{value:"fil-ph-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"fil-ph-Neural2-D", label: "Neural2 - MALE"}
                ],
                "fi-FI": [
                    {value:"fi-FI-Standard-A", label:"Sofia (Female)"},
                    {value:"fi-FI-Wavenet-A", label:"Sofianna (Female)"}
                ],
                "fr-CA": [
                    //{value:"fr-CA-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"fr-CA-Neural2-B", label: "Neural2 - MALE"},
                    //{value:"fr-CA-Neural2-C", label: "Neural2 - FEMALE"},
                    //{value:"fr-CA-Neural2-D", label: "Neural2 - MALE"},
                    {value:"fr-CA-Standard-A", label:"Emma (Female)"},
                    {value:"fr-CA-Standard-B", label:"Jean (Male)"},
                    {value:"fr-CA-Standard-C", label:"Gabrielle (Female)"},
                    {value:"fr-CA-Standard-D", label:"Thomas (Male)"},
                    {value:"fr-CA-Wavenet-A", label:"Amelie (Female)"},
                    {value:"fr-CA-Wavenet-B", label:"Antoine (Male)"},
                    {value:"fr-CA-Wavenet-C", label:"Gabrielle (Female)"},
                    {value:"fr-CA-Wavenet-D", label:"Thomas (Male)"}
                ],
                "fr-FR": [
                    //{value:"fr-FR-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"fr-FR-Neural2-B", label: "Neural2 - MALE"},
                    //{value:"fr-FR-Neural2-C", label: "Neural2 - FEMALE"},
                    //{value:"fr-FR-Neural2-D", label: "Neural2 - MALE"},
                    //{value:"fr-FR-Neural2-E", label: "Neural2 - FEMALE"},
                    //{value:"fr-FR-Polyglot-1", label:"Jean (Male)"},
                    {value:"fr-FR-Standard-A", label:"Marie (Female)"},
                    {value:"fr-FR-Standard-B", label:"Pierre (Male)"},
                    {value:"fr-FR-Standard-C", label:"Sophie (Female)"},
                    {value:"fr-FR-Standard-D", label:"Paul (Male)"},
                    {value:"fr-FR-Standard-E", label:"Julie (Female)"},
                    {value:"fr-FR-Wavenet-A", label:"Elise (Female)"},
                    {value:"fr-FR-Wavenet-B", label:"Nicolas (Male)"},
                    {value:"fr-FR-Wavenet-C", label:"Clara (Female)"},
                    {value:"fr-FR-Wavenet-D", label:"Antoine (Male)"},
                    {value:"fr-FR-Wavenet-E", label:"Amelie (Female)"}
                ],
                "gl-ES": [
                    {value:"gl-ES-Standard-A", label:"Ana (Female)"}
                ],
                "de-DE": [
                    //{value:"de-DE-Neural2-B", label: "Neural2 - MALE"},
                    //{value:"de-DE-Neural2-C", label: "Neural2 - FEMALE"},
                    //{value:"de-DE-Neural2-D", label: "Neural2 - MALE"},
                    //{value:"de-DE-Neural2-F", label: "Neural2 - FEMALE"},
                    //{value:"de-DE-Polyglot-1", label:"Johannes (Male)"},
                    {value:"de-DE-Standard-A", label:"Anna (Female)"},
                    {value:"de-DE-Standard-B", label:"Max (Male)"},
                    {value:"de-DE-Standard-C", label:"Sophia (Female)"},
                    {value:"de-DE-Standard-D", label:"Paul (Male)"},
                    {value:"de-DE-Standard-E", label:"Erik (Male)"},
                    {value:"de-DE-Standard-F", label:"Lina (Female)"},
                    {value:"de-DE-Wavenet-A", label:"Eva (Female)"},
                    {value:"de-DE-Wavenet-B", label:"Felix (Male)"},
                    {value:"de-DE-Wavenet-C", label:"Emma (Female)"},
                    {value:"de-DE-Wavenet-D", label:"Lukas (Male)"},
                    {value:"de-DE-Wavenet-E", label:"Nico (Male)"},
                    {value:"de-DE-Wavenet-F", label:"Mia (Female)"}
                ],
                "el-GR": [
                    {value:"el-GR-Standard-A", label:"Ελένη (Female)"},
                    {value:"el-GR-Wavenet-A", label:"Ελένη (Female)"}
                ],
                "gu-IN": [
                    {value:"gu-IN-Standard-A", label:"દિવ્યા (Female)"},
                    {value:"gu-IN-Standard-B", label:"કિશોર (Male)"},
                    {value:"gu-IN-Wavenet-A", label:"દિવ્યા (Female)"},
                    {value:"gu-IN-Wavenet-B", label:"કિશોર (Male)"}
                ],
                "he-IL": [
                    {value:"he-IL-Standard-A", label:"Tamar (Female)"},
                    {value:"he-IL-Standard-B", label:"David (Male)"},
                    {value:"he-IL-Standard-C", label:"Michal (Female)"},
                    {value:"he-IL-Standard-D", label:"Jonathan (Male)"},
                    {value:"he-IL-Wavenet-A", label:"Yael (Female)"},
                    {value:"he-IL-Wavenet-B", label:"Eli (Male)"},
                    {value:"he-IL-Wavenet-C", label:"Abigail (Female)"},
                    {value:"he-IL-Wavenet-D", label:"Alex (Male)"}
                ],
                "hi-IN": [
                    //{value:"hi-IN-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"hi-IN-Neural2-B", label: "Neural2 - MALE"},
                    //{value:"hi-IN-Neural2-C", label: "Neural2 - MALE"},
                    //{value:"hi-IN-Neural2-D", label: "Neural2 - FEMALE"},
                    {value:"hi-IN-Standard-A", label:"Aditi (Female)"},
                    {value:"hi-IN-Standard-B", label:"Abhishek (Male)"},
                    {value:"hi-IN-Standard-C", label:"Aditya (Male)"},
                    {value:"hi-IN-Standard-D", label:"Anjali (Female)"},
                    {value:"hi-IN-Wavenet-A", label:"Kiara (Female)"},
                    {value:"hi-IN-Wavenet-B", label:"Rohan (Male)"},
                    {value:"hi-IN-Wavenet-C", label:"Rishabh (Male)"},
                    {value:"hi-IN-Wavenet-D", label:"Srishti (Female)"}
                ],
                "hu-HU": [
                    {value:"hu-HU-Standard-A", label:"Eszter (Female)"},
                    {value:"hu-HU-Wavenet-A", label:"Lilla (Female)"}
                ],
                "is-IS": [
                    {value:"is-IS-Standard-A", label:"Guðrún (Female)"}
                ],
                "id-ID": [
                    {value:"id-ID-Standard-A", label:"Amelia (Female)"},
                    {value:"id-ID-Standard-B", label:"Fajar (Male)"},
                    {value:"id-ID-Standard-C", label:"Galih (Male)"},
                    {value:"id-ID-Standard-D", label:"Kiara (Female)"},
                    {value:"id-ID-Wavenet-A", label:"Nadia (Female)"},
                    {value:"id-ID-Wavenet-B", label:"Reza (Male)"},
                    {value:"id-ID-Wavenet-C", label:"Satria (Male)"},
                    {value:"id-ID-Wavenet-D", label:"Vania (Female)"}
                ],
                "it-IT": [
                    //{value:"it-IT-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"it-IT-Neural2-C", label: "Neural2 - MALE"},
                    {value:"it-IT-Standard-A", label:"Chiara (Female)"},
                    {value:"it-IT-Standard-B", label:"Elisa (Female)"},
                    {value:"it-IT-Standard-C", label:"Matteo (Male)"},
                    {value:"it-IT-Standard-D", label:"Riccardo (Male)"},
                    {value:"it-IT-Wavenet-A", label:"Valentina (Female)"},
                    {value:"it-IT-Wavenet-B", label:"Vittoria (Female)"},
                    {value:"it-IT-Wavenet-C", label:"Andrea (Male)"},
                    {value:"it-IT-Wavenet-D", label:"Luca (Male)"}
                ],
                "ja-JP": [
                    //{value:"ja-JP-Neural2-B", label: "Neural2 - FEMALE"},
                    //{value:"ja-JP-Neural2-C", label: "Neural2 - MALE"},
                    //{value:"ja-JP-Neural2-D", label: "Neural2 - MALE"},
                    {value:"ja-JP-Standard-A", label:"Akane (Female)"},
                    {value:"ja-JP-Standard-B", label:"Emi (Female)"},
                    {value:"ja-JP-Standard-C", label:"Daisuke (Male)"},
                    {value:"ja-JP-Standard-D", label:"Kento (Male)"},
                    {value:"ja-JP-Wavenet-A", label:"Haruka (Female)"},
                    {value:"ja-JP-Wavenet-B", label:"Rin (Female)"},
                    {value:"ja-JP-Wavenet-C", label:"Shun (Male)"},
                    {value:"ja-JP-Wavenet-D", label:"Yuta (Male)"}
                ],
                "kn-IN": [
                    {value:"kn-IN-Standard-A", label:"Dhanya (Female)"},
                    {value:"kn-IN-Standard-B", label:"Keerthi (Male)"},
                    {value:"kn-IN-Wavenet-A", label:"Meena (Female)"},
                    {value:"kn-IN-Wavenet-B", label:"Nandini (Male)"}
                ],
                "ko-KR": [
                    //{value:"ko-KR-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"ko-KR-Neural2-B", label: "Neural2 - FEMALE"},
                    //{value:"ko-KR-Neural2-C", label: "Neural2 - MALE"},
                    {value:"ko-KR-Standard-A", label:"So-young (Female)"},
                    {value:"ko-KR-Standard-B", label:"Se-yeon (Female)"},
                    {value:"ko-KR-Standard-C", label:"Min-soo (Male)"},
                    {value:"ko-KR-Standard-D", label:"Seung-woo (Male)"},
                    {value:"ko-KR-Wavenet-A", label:"Ji-soo (Female)"},
                    {value:"ko-KR-Wavenet-B", label:"Yoon-a (Female)"},
                    {value:"ko-KR-Wavenet-C", label:"Tae-hyun (Male)"},
                    {value:"ko-KR-Wavenet-D", label:"Jun-ho (Male)"}
                ],
                "lv-LV": [
                    {value:"lv-LV-Standard-A", label:"Raivis (Male)"}
                ],
                "lv-LT": [
                    {value:"lv-LT-Standard-A", label: "Raivis (Male)"}
                ],
                "ms-MY": [
                    {value:"ms-MY-Standard-A", label:"Amira (Female)"},
                    {value:"ms-MY-Standard-B", label:"Danial (Male)"},
                    {value:"ms-MY-Standard-C", label:"Eira (Female)"},
                    {value:"ms-MY-Standard-D", label:"Farhan (Male)"},
                    {value:"ms-MY-Wavenet-A", label:"Hana (Female)"},
                    {value:"ms-MY-Wavenet-B", label:"Irfan (Male)"},
                    {value:"ms-MY-Wavenet-C", label:"Janna (Female)"},
                    {value:"ms-MY-Wavenet-D", label:"Khairul (Male)"}
                ],
                "ml-IN": [
                    {value:"ml-IN-Standard-A", label:"Aishwarya (Female)"},
                    {value:"ml-IN-Standard-B", label:"Dhruv (Male)"},
                    {value:"ml-IN-Wavenet-A", label:"Deepthi (Female)"},
                    {value:"ml-IN-Wavenet-B", label:"Gautam (Male)"},
                    {value:"ml-IN-Wavenet-C", label:"Isha (Female)"},
                    {value:"ml-IN-Wavenet-D", label:"Kabir (Male)"}
                ],
                "cmn-CN": [
                    {value:"cmn-CN-Standard-A", label:"Xiaomei (Female)"},
                    {value:"cmn-CN-Standard-B", label:"Lijun (Male)"},
                    {value:"cmn-CN-Standard-C", label:"Minghao (Male)"},
                    {value:"cmn-CN-Standard-D", label:"Yingying (Female)"},
                    {value:"cmn-CN-Wavenet-A", label:"Shanshan (Female)"},
                    {value:"cmn-CN-Wavenet-B", label:"Chenchen (Male)"},
                    {value:"cmn-CN-Wavenet-C", label:"Jiahao (Male)"},
                    {value:"cmn-CN-Wavenet-D", label:"Yueyu (Female)"}
                ],
                "cmn-TW": [
                    {value:"cmn-TW-Standard-A", label:"Jingwen (Female)"},
                    {value:"cmn-TW-Standard-B", label:"Jinghao (Male)"},
                    {value:"cmn-TW-Standard-C", label:"Tingting (Female)"},
                    {value:"cmn-TW-Wavenet-A", label:"Yunyun (Female)"},
                    {value:"cmn-TW-Wavenet-B", label:"Zhenghao (Male)"},
                    {value:"cmn-TW-Wavenet-C", label:"Yuehan (Female)"}
                ],
                "mr-IN": [
                    {value:"mr-IN-Standard-A", label:"Anjali (Female)"},
                    {value:"mr-IN-Standard-B", label:"Aditya (Male)"},
                    {value:"mr-IN-Standard-C", label:"Dipti (Female)"},
                    {value:"mr-IN-Wavenet-A", label:"Gauri (Female)"},
                    {value:"mr-IN-Wavenet-B", label:"Harsh (Male)"},
                    {value:"mr-IN-Wavenet-C", label:"Ishita (Female)"}
                ],
                "nb-NO": [
                    {value:"nb-NO-Standard-A", label:"Ingrid (Female)"},
                    {value:"nb-NO-Standard-B", label:"Jonas (Male)"},
                    {value:"nb-NO-Standard-C", label:"Marit (Female)"},
                    {value:"nb-NO-Standard-D", label:"Olav (Male)"},
                    {value:"nb-NO-Standard-E", label:"Silje (Female)"},
                    {value:"nb-NO-Wavenet-A", label:"Astrid (Female)"},
                    {value:"nb-NO-Wavenet-B", label:"Eirik (Male)"},
                    {value:"nb-NO-Wavenet-C", label:"Inger (Female)"},
                    {value:"nb-NO-Wavenet-D", label:"Kristian (Male)"},
                    {value:"nb-NO-Wavenet-E", label:"Trine (Female)"}
                ],
                "pl-PL": [
                    {value:"pl-PL-Standard-A", label:"Agata (Female)"},
                    {value:"pl-PL-Standard-B", label:"Bartosz (Male)"},
                    {value:"pl-PL-Standard-C", label:"Kamil (Male)"},
                    {value:"pl-PL-Standard-D", label:"Julia (Female)"},
                    {value:"pl-PL-Standard-E", label:"Magdalena (Female)"},
                    {value:"pl-PL-Wavenet-A", label:"Natalia (Female)"},
                    {value:"pl-PL-Wavenet-B", label:"Paweł (Male)"},
                    {value:"pl-PL-Wavenet-C", label:"Tomasz (Male)"},
                    {value:"pl-PL-Wavenet-D", label:"Zofia (Female)"},
                    {value:"pl-PL-Wavenet-E", label:"Wiktoria (Female)"}
                ],
                "pt-BR": [
                    //{value:"pt-BR-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"pt-BR-Neural2-B", label: "Neural2 - MALE"},
                    //{value:"pt-BR-Neural2-C", label: "Neural2 - FEMALE"},
                    {value:"pt-BR-Standard-A", label:"Ana (Female)"},
                    {value:"pt-BR-Standard-B", label:"Carlos (Male)"},
                    {value:"pt-BR-Standard-C", label:"Maria (Female)"},
                    {value:"pt-BR-Wavenet-A", label:"Julia (Female)"},
                    {value:"pt-BR-Wavenet-B", label:"João (Male)"},
                    {value:"pt-BR-Wavenet-C", label:"Fernanda (Female)"}
                ],
                "pt-PT": [
                    {value:"pt-PT-Standard-A", label:"Maria (Female)"},
                    {value:"pt-PT-Standard-B", label:"José (Male)"},
                    {value:"pt-PT-Standard-C", label:"Luís (Male)"},
                    {value:"pt-PT-Standard-D", label:"Ana (Female)"},
                    {value:"pt-PT-Wavenet-A", label:"Catarina (Female)"},
                    {value:"pt-PT-Wavenet-B", label:"Miguel (Male)"},
                    {value:"pt-PT-Wavenet-C", label:"João (Male)"},
                    {value:"pt-PT-Wavenet-D", label:"Marta (Female)"}
                ],
                "pa-IN": [
                    {value:"pa-IN-Standard-A", label:"Harpreet (Female)"},
                    {value:"pa-IN-Standard-B", label:"Gurpreet (Male)"},
                    {value:"pa-IN-Standard-C", label:"Jasmine (Female)"},
                    {value:"pa-IN-Standard-D", label:"Rahul (Male)"},
                    {value:"pa-IN-Wavenet-A", label:"Simran (Female)"},
                    {value:"pa-IN-Wavenet-B", label:"Amardeep (Male)"},
                    {value:"pa-IN-Wavenet-C", label:"Kiran (Female)"},
                    {value:"pa-IN-Wavenet-D", label:"Raj (Male)"}
                ],
                "ro-RO": [
                    {value:"ro-RO-Standard-A", label:"Maria (Female)"},
                    {value:"ro-RO-Wavenet-A", label:"Ioana (Female)"}
                ],
                "ru-RU": [
                    {value:"ru-RU-Standard-A", label:"Anastasia"},
                    {value:"ru-RU-Standard-B", label:"Alexander"},
                    {value:"ru-RU-Standard-C", label:"Elizabeth"},
                    {value:"ru-RU-Standard-D", label:"Michael"},
                    {value:"ru-RU-Standard-E", label:"Victoria"},
                    {value:"ru-RU-Wavenet-A", label:"Daria"},
                    {value:"ru-RU-Wavenet-B", label:"Dmitry"},
                    {value:"ru-RU-Wavenet-C", label:"Kristina"},
                    {value:"ru-RU-Wavenet-D", label:"Ivan"},
                    {value:"ru-RU-Wavenet-E", label:"Sophia"}
                ],
                "sr-RS": [
                    {value:"sr-RS-Standard-A", label:"Ana"}
                ],
                "sk-SK": [
                    {value:"sk-SK-Standard-A", label:"Mária (Female)"},
                    {value:"sk-SK-Wavenet-A", label:"Zuzana (Female)"}
                ],
                "es-ES": [
                    //{value:"es-ES-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"es-ES-Neural2-B", label: "Neural2 - MALE"},
                    //{value:"es-ES-Neural2-C", label: "Neural2 - FEMALE"},
                    //{value:"es-ES-Neural2-D", label: "Neural2 - FEMALE"},
                    //{value:"es-ES-Neural2-E", label: "Neural2 - FEMALE"},
                    //{value:"es-ES-Neural2-F", label: "Neural2 - MALE"},
                    //{value: "es-ES-Polyglot-1", label: "Juan (Male)"},
                    {value: "es-ES-Standard-A", label: "María (Female)"},
                    {value: "es-ES-Standard-B", label: "José (Male)"},
                    {value: "es-ES-Standard-C", label: "Ana (Female)"},
                    {value: "es-ES-Standard-D", label: "Isabel (Female)"},
                    {value: "es-ES-Wavenet-B", label: "Pedro (Male)"},
                    {value: "es-ES-Wavenet-C", label: "Laura (Female)"},
                    {value: "es-ES-Wavenet-D", label: "Julia (Female)"}

                ],
                "es-US": [
                    //{value:"es-US-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"es-US-Neural2-B", label: "Neural2 - MALE"},
                    //{value:"es-US-Neural2-C", label: "Neural2 - MALE"},
                    {value:"es-US-News-D", label: "Diego (Male)"},
                    {value:"es-US-News-E", label: "Eduardo (Male)"},
                    {value:"es-US-News-F", label: "Fátima (Female)"},
                    {value:"es-US-News-G", label: "Gabriela (Female)"},
                    //{value:"es-US-Polyglot-1", label: "Juan (Male)"},
                    {value:"es-US-Standard-A", label: "Ana (Female)"},
                    {value:"es-US-Standard-B", label: "José (Male)"},
                    {value:"es-US-Standard-C", label: "Carlos (Male)"},
                    {value:"es-US-Studio-B", label: "Miguel (Male)"},
                    {value:"es-US-Wavenet-A", label: "Laura (Female)"},
                    {value:"es-US-Wavenet-B", label: "Pedro (Male)"},
                    {value:"es-US-Wavenet-C", label: "Pablo (Male)"}
                ],
                "sv-SE": [
                    {value:"sv-SE-Standard-A", label: "Ebba (Female)"},
                    {value:"sv-SE-Standard-B", label: "Saga (Female)"},
                    {value:"sv-SE-Standard-C", label: "Linnea (Female)"},
                    {value:"sv-SE-Standard-D", label: "Erik (Male)"},
                    {value:"sv-SE-Standard-E", label: "Anton (Male)"},
                    {value:"sv-SE-Wavenet-A", label: "Astrid (Female)"},
                    {value:"sv-SE-Wavenet-B", label: "Elin (Female)"},
                    {value:"sv-SE-Wavenet-C", label: "Oskar (Male)"},
                    {value:"sv-SE-Wavenet-D", label: "Hanna (Female)"},
                    {value:"sv-SE-Wavenet-E", label: "Felix (Male)"}
                ],
                "ta-IN": [
                    {value:"ta-IN-Standard-A", label: "Anjali (Female)"},
                    {value:"ta-IN-Standard-B", label: "Karthik (Male)"},
                    {value:"ta-IN-Standard-C", label: "Priya (Female)"},
                    {value:"ta-IN-Standard-D", label: "Ravi (Male)"},
                    {value:"ta-IN-Wavenet-A", label: "Lakshmi (Female)"},
                    {value:"ta-IN-Wavenet-B", label: "Suresh (Male)"},
                    {value:"ta-IN-Wavenet-C", label: "Uma (Female)"},
                    {value:"ta-IN-Wavenet-D", label: "Venkatesh (Male)"}
                ],
                "te-IN": [
                    {value:"-IN-Standard-A", label: "Anjali - (Female)"},
                    {value:"-IN-Standard-B", label: "Karthik - (Male)"}
                ],
                "th-TH": [
                    //{value:"th-TH-Neural2-C", label: "Neural2 - FEMALE"},
                    {value:"th-TH-Standard-A", label: "Ariya - (Female)"}
                ],
                "tr-TR": [
                    {value:"tr-TR-Standard-A", label: "Ayşe (Female)"},
                    {value:"tr-TR-Standard-B", label: "Berk (Male)"},
                    {value:"tr-TR-Standard-C", label: "Cansu (Female)"},
                    {value:"tr-TR-Standard-D", label: "Deniz (Female)"},
                    {value:"tr-TR-Standard-E", label: "Emre (Male)"},
                    {value:"tr-TR-Wavenet-A", label: "Gül (Female)"},
                    {value:"tr-TR-Wavenet-B", label: "Mert (Male)"},
                    {value:"tr-TR-Wavenet-C", label: "Nilay (Female)"},
                    {value:"tr-TR-Wavenet-D", label: "Selin (Female)"},
                    {value:"tr-TR-Wavenet-E", label: "Tolga (Male)"}
                ],
                "uk-UA": [
                    {value:"uk-UA-Standard-A", label: "Anya - (Female)"},
                    {value:"uk-UA-Wavenet-A", label: "Dasha - (Female)"}
                ],
                "vi-VN": [
                    //{value:"vi-VN-Neural2-A", label: "Neural2 - FEMALE"},
                    //{value:"vi-VN-Neural2-D", label: "Neural2 - MALE"},
                    {value:"vi-VN-Standard-A", label: "Mai (Female)"},
                    {value:"vi-VN-Standard-B", label: "Nam (Male)"},
                    {value:"vi-VN-Standard-C", label: "Hoa (Female)"},
                    {value:"vi-VN-Standard-D", label: "Huy (Male)"},
                    {value:"vi-VN-Wavenet-A", label: "Lan (Female)"},
                    {value:"vi-VN-Wavenet-B", label: "Son (Male)"},
                    {value:"vi-VN-Wavenet-C", label: "Thao (Female)"},
                    {value:"vi-VN-Wavenet-D", label: "Tuan (Male)"}
                ]
            }

            function country2flag(languageCode) {
                var countryCode = languageCode.match(/[A-Z]{2}$/i);
                if (!countryCode) {
                    return null;
                }
                var flag = countryCode[0].replace(/./g, function(letter) {
                    return String.fromCodePoint(letter.charCodeAt(0) % 32 + 0x1F1E5);
                });
                return flag;
            }

            $(document).ready(function() {
                "use strict";

                populateVoiceSelect();

                $("#languages").on("change", function() {
                populateVoiceSelect();
                });

                function populateVoiceSelect() {
                const selectedLanguage = $("#languages").val();
                const selectedOptions = voicesData[selectedLanguage];
                const voiceSelect = $("#voice");

                voiceSelect.empty();

                if (selectedOptions) {
                    selectedOptions.forEach(option => {
                    $("<option></option>")
                        .val(option.value)
                        .text(option.label)
                        .appendTo(voiceSelect);
                    });
                }
                }

                $('.add-new-text').click(function() {
                    var selectedVoice = $('#voice option:selected').val();
                    var selectedVoiceText = $('#voice option:selected').text();
                    var selectedLang = $('#languages option:selected').val();
                    var selectedPace = $('#pace option:selected').val();
                    var selectedBreak = $('#break option:selected').val();

                    var speechContent = `
                        <div class="speech mb-3">
                            <div class="speech-info flex items-center space-x-2 mb-2">
                                <div>
                                    <span class="data-lang text-lg mr-1">${country2flag(selectedLang)}</span>
                                    <span class="data-voice">${selectedVoiceText}</span>
                                </div>
                                <div>
                                    <select class="form-control form-select bg-[#fff] placeholder:text-black say-as">
                                        <option value="0" selected>{{__('say-as')}}</option>
                                        <option value="currency">{{__('currency')}}</option>
                                        <option value="telephone">{{__('telephone')}}</option>
                                        <option value="verbatim">{{__('verbatim')}}</option>
                                        <option value="date">{{__('date')}}</option>
                                        <option value="characters">{{__('characters')}}</option>
                                        <option value="cardinal">{{__('cardinal')}}</option>
                                        <option value="ordinal">{{__('ordinal')}}</option>
                                        <option value="fraction">{{__('fraction')}}</option>
                                        <option value="bleep">{{__('bleep')}}</option>
                                        <option value="unit">{{__('unit')}}</option>
                                        <option value="unit">{{__('time')}}</option>
                                    </select>
                                </div>
                                <div class="flex items-center !gap-1 !ms-auto">
                                    <div class="data-preview"></div>
                                    <button type="button" class="preview-speech btn w-[36px] h-[36px] p-0 border group" title="{{__('Preview')}}">
                                        <svg class="speach group-[.loading]:hidden" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g><mask id="mask0_966_390" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="24" height="24"><rect width="24" height="24" fill="currentColor"/></mask><g mask="url(#mask0_966_390)"><path d="M15.8278 12.75V11.2501H19.4431V12.75H15.8278ZM16.9701 19.4808L14.0778 17.3116L14.9893 16.1154L17.8816 18.2846L16.9701 19.4808ZM14.9508 7.84619L14.0393 6.65006L16.9316 4.48083L17.8431 5.67696L14.9508 7.84619ZM3.55859 14.5V9.50006H7.27012L11.5585 5.21166V18.7884L7.27012 14.5H3.55859ZM10.0586 8.85004L7.90857 11H5.05857V13H7.90857L10.0586 15.15V8.85004Z" fill="#1C1B1F"/></g></g>
                                        </svg>
										<span>
										<svg class="lqd-icon-loader animate-spin hidden group-[.loading]:block" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path d="M20 11a8.1 8.1 0 0 0 -15.5 -2m-.5 -4v4h4"></path> <path d="M4 13a8.1 8.1 0 0 0 15.5 2m.5 4v-4h-4"></path> </svg>
                                    </button>
                                    <button type="button" class="delete-speech btn w-[36px] h-[36px] p-0 border hover:bg-red-500 hover:text-white" title="{{__('Delete')}}">
                                        <svg width="10" height="10" viewBox="0 0 10 10" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M9.08789 1.74609L5.80664 5L9.08789 8.25391L8.26758 9.07422L4.98633 5.82031L1.73242 9.07422L0.912109 8.25391L4.16602 5L0.912109 1.74609L1.73242 0.925781L4.98633 4.17969L8.26758 0.925781L9.08789 1.74609Z"/>
                                        </svg>
                                    </button>
                                </div>
                            </div>
                            <textarea data-voice="${selectedVoice}" data-lang="${selectedLang}" data-pace="${selectedPace}" data-break="${selectedBreak}" placeholder="{{__('write something...')}}" class="form-control bg-[#fff] placeholder:text-gray" cols="30" rows="3"></textarea>
                        </div>
                    `;

                    $('.speeches').append(speechContent);
                });

                $(document).on('click', '.delete-speech', function() {
                    $(this).closest('.speech').remove();
                });

                $(document).on('change', '.say-as', function() {
                    var selectedValue = $(this).val();
                    if ( selectedValue === 'currency' ){
                        selectedValue = "<say-as interpret-as='currency' language='en-US'>$42.01</say-as>";
                    } else if ( selectedValue === 'telephone' ){
                        selectedValue = "<say-as interpret-as='telephone' google:style='zero-as-zero'>1800-202-1212</say-as>";
                    } else if ( selectedValue === 'verbatim' ){
                        selectedValue = "<say-as interpret-as='verbatim'>abcdefg</say-as>";
                    } else if ( selectedValue === 'date' ){
                        selectedValue = "<say-as interpret-as='date' format='yyyymmdd' detail='1'>1960-09-10</say-as>";
                    } else if ( selectedValue === 'characters' ){
                        selectedValue = "<say-as interpret-as='characters'>can</say-as>";
                    } else if ( selectedValue === 'cardinal' ){
                        selectedValue = "<say-as interpret-as='cardinal'>12345</say-as>";
                    } else if ( selectedValue === 'ordinal' ){
                        selectedValue = "<say-as interpret-as='ordinal'>1</say-as>";
                    } else if ( selectedValue === 'fraction' ){
                        selectedValue = "<say-as interpret-as='fraction'>5+1/2</say-as>";
                    } else if ( selectedValue === 'bleep' ){
                        selectedValue = "<say-as interpret-as='expletive'>censor this</say-as>";
                    } else if ( selectedValue === 'unit' ){
                        selectedValue = "<say-as interpret-as='unit'>10 foot</say-as>";
                    } else if ( selectedValue === 'time' ){
                        selectedValue = "<say-as interpret-as='time' format='hms12'>2:30pm</say-as>";
                    }
                    var textarea = $(this).closest('.speech').find('textarea');
                    var existingValue = textarea.val();
                    textarea.val(existingValue + selectedValue);
                    $(this).val('0');
                });

                // Preview
                $(document).on('click', '.preview-speech', function() {
					const previewButton = $(this);
                    var speechElement = $(this).closest('.speech');
                    var textareaValue = speechElement.find('textarea').val();

                    if (textareaValue) {
                        previewButton.addClass('loading');

                        var formData = new FormData();
                        var speechData = [];

                        var data = {
                            voice:   speechElement.find('textarea').attr('data-voice'),
                            lang:    speechElement.find('textarea').attr('data-lang'),
                            pace:    speechElement.find('textarea').attr('data-pace'),
                            break:   speechElement.find('textarea').attr('data-break'),
                            content: textareaValue
                        };
                        speechData.push(data);

                        var jsonData = JSON.stringify(speechData);
                        formData.append( 'speeches', jsonData );
                        formData.append( 'preview', true );

                        $.ajax( {
                            type: "post",
                            headers: {
                                'X-CSRF-TOKEN': "{{ csrf_token() }}",
                            },
                            url: "/dashboard/user/openai/generate-speech",
                            data: formData,
                            contentType: false,
                            processData: false,
                            success: function ( data ) {
                                toastr.success( 'Generated' );
                                document.getElementById( "generate_speech_button" ).disabled = false;
                                document.getElementById( "generate_speech_button" ).innerHTML = "Generate";
                                speechElement.find('.data-preview').html(data.output);
                                generateWaveForm(speechElement[0].querySelector('.data-audio'));
								previewButton.removeClass('loading');
                            },
                            error: function ( data ) {
                                var err = data.responseJSON.errors;
                                $.each( err, function ( index, value ) {
                                    toastr.error( value );
                                } );
                                document.getElementById( "generate_speech_button" ).disabled = false;
                                document.getElementById( "generate_speech_button" ).innerHTML = "Save";
								previewButton.removeClass('loading');
                            },
                        } );
                    }else{
                        toastr.error('Input is empty!');
                    }

                });

            });


        </script>
    @endif

    @if($openai->type == 'code')
        <link rel="stylesheet" href="/assets/libs/prism/prism.css">
        <script src="/assets/libs/prism/prism.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', (event) => {
				"use strict";

                const codeLang = document.querySelector('#code_lang');
                const codePre = document.querySelector('#code-pre');
                const codeOutput = codePre?.querySelector('#code-output');

                if (!codeOutput) return;

                codePre.classList.add(`language-${codeLang && codeLang.value !== '' ? codeLang.value : 'javascript'}`);

                // saving for copy
                window.codeRaw = codeOutput.innerText;

                Prism.highlightElement(codeOutput);
            });
        </script>
    @endif

    <script>
        function sendOpenaiGeneratorForm(ev) {
			"use strict";

			function hideLoadingIndicators() {
				document.getElementById("openai_generator_button").disabled = false;
				document.getElementById("openai_generator_button").innerHTML = "Regenerate";
				document.querySelector('#app-loading-indicator')?.classList?.add('opacity-0');
				document.querySelector('#workbook_regenerate')?.classList?.remove('hidden');
			}

			ev?.preventDefault();
			ev?.stopPropagation();

            document.getElementById("openai_generator_button").disabled = true;
            document.getElementById("openai_generator_button").innerHTML = magicai_localize.please_wait;
			document.querySelector('#app-loading-indicator')?.classList?.remove('opacity-0');
            @if($openai->type == 'image')
                var imageGenerator = document.querySelector('.form-selectgroup-item-image-gen input:checked').value;
            @endif
            var formData = new FormData();
            formData.append('post_type', '{{$openai->slug}}');
            formData.append('openai_id', {{$openai->id}});
            formData.append('custom_template', {{$openai->custom_template}});
            @if($openai->type == 'text')
            formData.append('maximum_length', $("#maximum_length").val());
            formData.append('number_of_results', $("#number_of_results").val());
            formData.append('creativity', $("#creativity").val());
            formData.append('tone_of_voice', $("#tone_of_voice").val());
            formData.append('language', $("#language").val());
            @endif
            @if($openai->type == 'audio')
            formData.append('file', $('#file').prop('files')[0]);
            @endif

            @if($openai->type == 'image')
            formData.append('image_style', $("#image_style").val());
            formData.append('image_lighting', $("#image_lighting").val());
            formData.append('image_mood', $("#image_mood").val());
            formData.append('image_number_of_images', $("#image_number_of_images").val());
            formData.append('image_generator', imageGenerator);
            formData.append('negative_prompt', $("#negative_prompt").val());
            @endif

            @foreach(json_decode($openai->questions) as $question)
            formData.append('{{$question->name}}', $("{{'#'.$question->name}}").val());
            @endforeach

            $.ajax({
                type: "post",
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}",
                },
                url: "/dashboard/user/openai/generate",
                data: formData,
                contentType: false,
                processData: false,
                success: function (res) {

					if ( res.status !== 'success' && ( res.message ) ) {
						toastr.error(res.message);
						hideLoadingIndicators();
						return;
					}

					//show successful message
					@if($openai->type == 'image') toastr.success(`Image Generated Successfully in ${res.image_storage}`);
					@else toastr.success('Generated Successfully!');
					@endif

					setTimeout(function () {
						@if($openai->type == 'image')

							const images = res.images;
							const imageContainer = document.querySelector('.image-results');
							images.forEach((image)=>{
								const imageResultTemplate = document.querySelector( '#image_result' ).content.cloneNode( true );
								imageResultTemplate.querySelector('.image-result img').setAttribute('src', image.output);
								imageResultTemplate.querySelector('.image-result span').innerHTML = image.response;
								imageResultTemplate.querySelector('.image-result span').setAttribute('class', image.response == "SD" ? "badge bg-blue text-white" : "badge bg-white text-red")
								imageResultTemplate.querySelector('.image-result a.download').setAttribute('href', image.output);
								imageResultTemplate.querySelector('.image-result a.gallery').setAttribute('href', image.output);
								const currenturl = window.location.href;
								const server = currenturl.split('/')[0];
								const delete_url = `${server}/dashboard/user/openai/documents/delete/image/${image.slug}`;
								imageResultTemplate.querySelector('.image-result a.delete').setAttribute('href', delete_url);
								imageResultTemplate.querySelector('.image-result a.download').setAttribute('href', image.output);
								imageResultTemplate.querySelector('.image-result p.text-heading').setAttribute('title', image.input);
								imageResultTemplate.querySelector('.image-result p.text-heading').innerHTML = image.input;
								imageResultTemplate.querySelector('.image-result p.text-muted').innerHTML = '';
								imageContainer.insertBefore(imageResultTemplate, imageContainer.firstChild);
							})

						@elseif($openai->type == 'audio')
							$("#generator_sidebar_table").html(res?.data?.html2 || res.html2);
						@else
							if ( $("#code-output").length ) {
								$("#workbook_textarea").html(res.data.html2);
								window.codeRaw = $("#code-output").text();
								$("#code-output").addClass(`language-${$('#code_lang').val() || 'javascript'}`);
								Prism.highlightElement($("#code-output")[0]);
							} else {
								tinymce.activeEditor.destroy();
								$("#generator_sidebar_table").html(res.data.html2);
								getResult();
							}
						@endif
						hideLoadingIndicators();
                        refreshFsLightbox();
					}, 750);
                },
                error: function (data) {
                    console.log(data);
                    if ( data.responseJSON.errors ) {
						$.each(data.responseJSON.errors, function(index, value) {
							toastr.error(value);
						});
					} else if ( data.responseJSON.message ) {
						toastr.error(data.responseJSON.message);
					}
                    document.getElementById("openai_generator_button").disabled = false;
                    document.getElementById("openai_generator_button").innerHTML = "Genarate";
					document.querySelector('#app-loading-indicator')?.classList?.add('opacity-0');
					document.querySelector('#workbook_regenerate')?.classList?.add('hidden');
                }
            });
            return false;
        }

    </script>
@endsection
