<?php
/**
 * RowsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Hubdb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Hubdb
 *
 * HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field.  HubDB tables support `draft` and `published` versions. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed, and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the published version of the data without disrupting it. If a table is set to be `allowed for public access`, you can access the published version of the table and rows without any authentication by specifying the portal id via the query parameter `portalId`.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\Hubdb\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Cms\Hubdb\ApiException;
use HubSpot\Client\Cms\Hubdb\Configuration;
use HubSpot\Client\Cms\Hubdb\HeaderSelector;
use HubSpot\Client\Cms\Hubdb\ObjectSerializer;

/**
 * RowsApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Hubdb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class RowsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'cloneDraftTableRow' => [
            'application/json',
        ],
        'createTableRow' => [
            'application/json',
        ],
        'getDraftTableRowById' => [
            'application/json',
        ],
        'getTableRow' => [
            'application/json',
        ],
        'getTableRows' => [
            'application/json',
        ],
        'purgeDraftTableRow' => [
            'application/json',
        ],
        'readDraftTableRows' => [
            'application/json',
        ],
        'replaceDraftTableRow' => [
            'application/json',
        ],
        'updateDraftTableRow' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation cloneDraftTableRow
     *
     * Clone a row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function cloneDraftTableRow($table_id_or_name, $row_id, string $contentType = self::contentTypes['cloneDraftTableRow'][0])
    {
        list($response) = $this->cloneDraftTableRowWithHttpInfo($table_id_or_name, $row_id, $contentType);
        return $response;
    }

    /**
     * Operation cloneDraftTableRowWithHttpInfo
     *
     * Clone a row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function cloneDraftTableRowWithHttpInfo($table_id_or_name, $row_id, string $contentType = self::contentTypes['cloneDraftTableRow'][0])
    {
        $request = $this->cloneDraftTableRowRequest($table_id_or_name, $row_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation cloneDraftTableRowAsync
     *
     * Clone a row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cloneDraftTableRowAsync($table_id_or_name, $row_id, string $contentType = self::contentTypes['cloneDraftTableRow'][0])
    {
        return $this->cloneDraftTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation cloneDraftTableRowAsyncWithHttpInfo
     *
     * Clone a row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cloneDraftTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, string $contentType = self::contentTypes['cloneDraftTableRow'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
        $request = $this->cloneDraftTableRowRequest($table_id_or_name, $row_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'cloneDraftTableRow'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function cloneDraftTableRowRequest($table_id_or_name, $row_id, string $contentType = self::contentTypes['cloneDraftTableRow'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling cloneDraftTableRow'
            );
        }

        // verify the required parameter 'row_id' is set
        if ($row_id === null || (is_array($row_id) && count($row_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $row_id when calling cloneDraftTableRow'
            );
        }
        if (!preg_match("/\\d+/", $row_id)) {
            throw new \InvalidArgumentException("invalid value for \"row_id\" when calling RowsApi.cloneDraftTableRow, must conform to the pattern /\\d+/.");
        }
        

        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft/clone';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($row_id !== null) {
            $resourcePath = str_replace(
                '{' . 'rowId' . '}',
                ObjectSerializer::toPathValue($row_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTableRow
     *
     * Add a new row to a table
     *
     * @param  string $table_id_or_name The ID or name of the target table. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The row definition JSON, formatted as described above. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function createTableRow($table_id_or_name, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['createTableRow'][0])
    {
        list($response) = $this->createTableRowWithHttpInfo($table_id_or_name, $hub_db_table_row_v3_request, $contentType);
        return $response;
    }

    /**
     * Operation createTableRowWithHttpInfo
     *
     * Add a new row to a table
     *
     * @param  string $table_id_or_name The ID or name of the target table. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The row definition JSON, formatted as described above. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTableRowWithHttpInfo($table_id_or_name, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['createTableRow'][0])
    {
        $request = $this->createTableRowRequest($table_id_or_name, $hub_db_table_row_v3_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTableRowAsync
     *
     * Add a new row to a table
     *
     * @param  string $table_id_or_name The ID or name of the target table. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The row definition JSON, formatted as described above. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTableRowAsync($table_id_or_name, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['createTableRow'][0])
    {
        return $this->createTableRowAsyncWithHttpInfo($table_id_or_name, $hub_db_table_row_v3_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTableRowAsyncWithHttpInfo
     *
     * Add a new row to a table
     *
     * @param  string $table_id_or_name The ID or name of the target table. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The row definition JSON, formatted as described above. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTableRowAsyncWithHttpInfo($table_id_or_name, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['createTableRow'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
        $request = $this->createTableRowRequest($table_id_or_name, $hub_db_table_row_v3_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTableRow'
     *
     * @param  string $table_id_or_name The ID or name of the target table. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The row definition JSON, formatted as described above. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createTableRowRequest($table_id_or_name, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['createTableRow'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling createTableRow'
            );
        }

        // verify the required parameter 'hub_db_table_row_v3_request' is set
        if ($hub_db_table_row_v3_request === null || (is_array($hub_db_table_row_v3_request) && count($hub_db_table_row_v3_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hub_db_table_row_v3_request when calling createTableRow'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($hub_db_table_row_v3_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($hub_db_table_row_v3_request));
            } else {
                $httpBody = $hub_db_table_row_v3_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDraftTableRowById
     *
     * Get a row from the draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableRowById'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function getDraftTableRowById($table_id_or_name, $row_id, string $contentType = self::contentTypes['getDraftTableRowById'][0])
    {
        list($response) = $this->getDraftTableRowByIdWithHttpInfo($table_id_or_name, $row_id, $contentType);
        return $response;
    }

    /**
     * Operation getDraftTableRowByIdWithHttpInfo
     *
     * Get a row from the draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableRowById'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDraftTableRowByIdWithHttpInfo($table_id_or_name, $row_id, string $contentType = self::contentTypes['getDraftTableRowById'][0])
    {
        $request = $this->getDraftTableRowByIdRequest($table_id_or_name, $row_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getDraftTableRowByIdAsync
     *
     * Get a row from the draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableRowById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDraftTableRowByIdAsync($table_id_or_name, $row_id, string $contentType = self::contentTypes['getDraftTableRowById'][0])
    {
        return $this->getDraftTableRowByIdAsyncWithHttpInfo($table_id_or_name, $row_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDraftTableRowByIdAsyncWithHttpInfo
     *
     * Get a row from the draft table
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableRowById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDraftTableRowByIdAsyncWithHttpInfo($table_id_or_name, $row_id, string $contentType = self::contentTypes['getDraftTableRowById'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
        $request = $this->getDraftTableRowByIdRequest($table_id_or_name, $row_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDraftTableRowById'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableRowById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDraftTableRowByIdRequest($table_id_or_name, $row_id, string $contentType = self::contentTypes['getDraftTableRowById'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling getDraftTableRowById'
            );
        }

        // verify the required parameter 'row_id' is set
        if ($row_id === null || (is_array($row_id) && count($row_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $row_id when calling getDraftTableRowById'
            );
        }
        if (!preg_match("/\\d+/", $row_id)) {
            throw new \InvalidArgumentException("invalid value for \"row_id\" when calling RowsApi.getDraftTableRowById, must conform to the pattern /\\d+/.");
        }
        

        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($row_id !== null) {
            $resourcePath = str_replace(
                '{' . 'rowId' . '}',
                ObjectSerializer::toPathValue($row_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTableRow
     *
     * Get a table row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function getTableRow($table_id_or_name, $row_id, string $contentType = self::contentTypes['getTableRow'][0])
    {
        list($response) = $this->getTableRowWithHttpInfo($table_id_or_name, $row_id, $contentType);
        return $response;
    }

    /**
     * Operation getTableRowWithHttpInfo
     *
     * Get a table row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTableRowWithHttpInfo($table_id_or_name, $row_id, string $contentType = self::contentTypes['getTableRow'][0])
    {
        $request = $this->getTableRowRequest($table_id_or_name, $row_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTableRowAsync
     *
     * Get a table row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTableRowAsync($table_id_or_name, $row_id, string $contentType = self::contentTypes['getTableRow'][0])
    {
        return $this->getTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTableRowAsyncWithHttpInfo
     *
     * Get a table row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, string $contentType = self::contentTypes['getTableRow'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
        $request = $this->getTableRowRequest($table_id_or_name, $row_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTableRow'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTableRowRequest($table_id_or_name, $row_id, string $contentType = self::contentTypes['getTableRow'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling getTableRow'
            );
        }

        // verify the required parameter 'row_id' is set
        if ($row_id === null || (is_array($row_id) && count($row_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $row_id when calling getTableRow'
            );
        }
        if (!preg_match("/\\d+/", $row_id)) {
            throw new \InvalidArgumentException("invalid value for \"row_id\" when calling RowsApi.getTableRow, must conform to the pattern /\\d+/.");
        }
        

        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($row_id !== null) {
            $resourcePath = str_replace(
                '{' . 'rowId' . '}',
                ObjectSerializer::toPathValue($row_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTableRows
     *
     * Get rows for a table
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. See the above description for more details. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function getTableRows($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['getTableRows'][0])
    {
        list($response) = $this->getTableRowsWithHttpInfo($table_id_or_name, $sort, $after, $limit, $properties, $contentType);
        return $response;
    }

    /**
     * Operation getTableRowsWithHttpInfo
     *
     * Get rows for a table
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. See the above description for more details. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTableRowsWithHttpInfo($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['getTableRows'][0])
    {
        $request = $this->getTableRowsRequest($table_id_or_name, $sort, $after, $limit, $properties, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTableRowsAsync
     *
     * Get rows for a table
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. See the above description for more details. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTableRowsAsync($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['getTableRows'][0])
    {
        return $this->getTableRowsAsyncWithHttpInfo($table_id_or_name, $sort, $after, $limit, $properties, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTableRowsAsyncWithHttpInfo
     *
     * Get rows for a table
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. See the above description for more details. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTableRowsAsyncWithHttpInfo($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['getTableRows'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging';
        $request = $this->getTableRowsRequest($table_id_or_name, $sort, $after, $limit, $properties, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTableRows'
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. See the above description for more details. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTableRowsRequest($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['getTableRows'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling getTableRows'
            );
        }






        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $properties,
            'properties', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation purgeDraftTableRow
     *
     * Permanently deletes a row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function purgeDraftTableRow($table_id_or_name, $row_id, string $contentType = self::contentTypes['purgeDraftTableRow'][0])
    {
        $this->purgeDraftTableRowWithHttpInfo($table_id_or_name, $row_id, $contentType);
    }

    /**
     * Operation purgeDraftTableRowWithHttpInfo
     *
     * Permanently deletes a row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function purgeDraftTableRowWithHttpInfo($table_id_or_name, $row_id, string $contentType = self::contentTypes['purgeDraftTableRow'][0])
    {
        $request = $this->purgeDraftTableRowRequest($table_id_or_name, $row_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation purgeDraftTableRowAsync
     *
     * Permanently deletes a row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function purgeDraftTableRowAsync($table_id_or_name, $row_id, string $contentType = self::contentTypes['purgeDraftTableRow'][0])
    {
        return $this->purgeDraftTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation purgeDraftTableRowAsyncWithHttpInfo
     *
     * Permanently deletes a row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function purgeDraftTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, string $contentType = self::contentTypes['purgeDraftTableRow'][0])
    {
        $returnType = '';
        $request = $this->purgeDraftTableRowRequest($table_id_or_name, $row_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'purgeDraftTableRow'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['purgeDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function purgeDraftTableRowRequest($table_id_or_name, $row_id, string $contentType = self::contentTypes['purgeDraftTableRow'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling purgeDraftTableRow'
            );
        }

        // verify the required parameter 'row_id' is set
        if ($row_id === null || (is_array($row_id) && count($row_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $row_id when calling purgeDraftTableRow'
            );
        }
        if (!preg_match("/\\d+/", $row_id)) {
            throw new \InvalidArgumentException("invalid value for \"row_id\" when calling RowsApi.purgeDraftTableRow, must conform to the pattern /\\d+/.");
        }
        

        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($row_id !== null) {
            $resourcePath = str_replace(
                '{' . 'rowId' . '}',
                ObjectSerializer::toPathValue($row_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation readDraftTableRows
     *
     * Get rows from draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. If you want to include multiple columns in the result, use this query param as many times. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function readDraftTableRows($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {
        list($response) = $this->readDraftTableRowsWithHttpInfo($table_id_or_name, $sort, $after, $limit, $properties, $contentType);
        return $response;
    }

    /**
     * Operation readDraftTableRowsWithHttpInfo
     *
     * Get rows from draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. If you want to include multiple columns in the result, use this query param as many times. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function readDraftTableRowsWithHttpInfo($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {
        $request = $this->readDraftTableRowsRequest($table_id_or_name, $sort, $after, $limit, $properties, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation readDraftTableRowsAsync
     *
     * Get rows from draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. If you want to include multiple columns in the result, use this query param as many times. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readDraftTableRowsAsync($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {
        return $this->readDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $sort, $after, $limit, $properties, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation readDraftTableRowsAsyncWithHttpInfo
     *
     * Get rows from draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. If you want to include multiple columns in the result, use this query param as many times. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function readDraftTableRowsAsyncWithHttpInfo($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableRowV3ForwardPaging';
        $request = $this->readDraftTableRowsRequest($table_id_or_name, $sort, $after, $limit, $properties, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'readDraftTableRows'
     *
     * @param  string $table_id_or_name The ID or name of the table to query. (required)
     * @param  string[] $sort Specifies the column names to sort the results by. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is &#x60;1000&#x60;. (optional)
     * @param  string[] $properties Specify the column names to get results containing only the required columns instead of all column details. If you want to include multiple columns in the result, use this query param as many times. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['readDraftTableRows'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function readDraftTableRowsRequest($table_id_or_name, $sort = null, $after = null, $limit = null, $properties = null, string $contentType = self::contentTypes['readDraftTableRows'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling readDraftTableRows'
            );
        }






        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/draft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $properties,
            'properties', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation replaceDraftTableRow
     *
     * Replaces an existing row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function replaceDraftTableRow($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['replaceDraftTableRow'][0])
    {
        list($response) = $this->replaceDraftTableRowWithHttpInfo($table_id_or_name, $row_id, $hub_db_table_row_v3_request, $contentType);
        return $response;
    }

    /**
     * Operation replaceDraftTableRowWithHttpInfo
     *
     * Replaces an existing row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function replaceDraftTableRowWithHttpInfo($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['replaceDraftTableRow'][0])
    {
        $request = $this->replaceDraftTableRowRequest($table_id_or_name, $row_id, $hub_db_table_row_v3_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation replaceDraftTableRowAsync
     *
     * Replaces an existing row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function replaceDraftTableRowAsync($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['replaceDraftTableRow'][0])
    {
        return $this->replaceDraftTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, $hub_db_table_row_v3_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation replaceDraftTableRowAsyncWithHttpInfo
     *
     * Replaces an existing row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function replaceDraftTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['replaceDraftTableRow'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
        $request = $this->replaceDraftTableRowRequest($table_id_or_name, $row_id, $hub_db_table_row_v3_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'replaceDraftTableRow'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['replaceDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function replaceDraftTableRowRequest($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['replaceDraftTableRow'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling replaceDraftTableRow'
            );
        }

        // verify the required parameter 'row_id' is set
        if ($row_id === null || (is_array($row_id) && count($row_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $row_id when calling replaceDraftTableRow'
            );
        }
        if (!preg_match("/\\d+/", $row_id)) {
            throw new \InvalidArgumentException("invalid value for \"row_id\" when calling RowsApi.replaceDraftTableRow, must conform to the pattern /\\d+/.");
        }
        
        // verify the required parameter 'hub_db_table_row_v3_request' is set
        if ($hub_db_table_row_v3_request === null || (is_array($hub_db_table_row_v3_request) && count($hub_db_table_row_v3_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hub_db_table_row_v3_request when calling replaceDraftTableRow'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($row_id !== null) {
            $resourcePath = str_replace(
                '{' . 'rowId' . '}',
                ObjectSerializer::toPathValue($row_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($hub_db_table_row_v3_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($hub_db_table_row_v3_request));
            } else {
                $httpBody = $hub_db_table_row_v3_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateDraftTableRow
     *
     * Updates an existing row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row with necessary fields that needs to be updated. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function updateDraftTableRow($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['updateDraftTableRow'][0])
    {
        list($response) = $this->updateDraftTableRowWithHttpInfo($table_id_or_name, $row_id, $hub_db_table_row_v3_request, $contentType);
        return $response;
    }

    /**
     * Operation updateDraftTableRowWithHttpInfo
     *
     * Updates an existing row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row with necessary fields that needs to be updated. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRow'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDraftTableRowWithHttpInfo($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['updateDraftTableRow'][0])
    {
        $request = $this->updateDraftTableRowRequest($table_id_or_name, $row_id, $hub_db_table_row_v3_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateDraftTableRowAsync
     *
     * Updates an existing row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row with necessary fields that needs to be updated. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDraftTableRowAsync($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['updateDraftTableRow'][0])
    {
        return $this->updateDraftTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, $hub_db_table_row_v3_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateDraftTableRowAsyncWithHttpInfo
     *
     * Updates an existing row
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row with necessary fields that needs to be updated. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDraftTableRowAsyncWithHttpInfo($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['updateDraftTableRow'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3';
        $request = $this->updateDraftTableRowRequest($table_id_or_name, $row_id, $hub_db_table_row_v3_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateDraftTableRow'
     *
     * @param  string $table_id_or_name The ID or name of the table (required)
     * @param  string $row_id The ID of the row (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableRowV3Request $hub_db_table_row_v3_request The JSON object of the row with necessary fields that needs to be updated. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTableRow'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateDraftTableRowRequest($table_id_or_name, $row_id, $hub_db_table_row_v3_request, string $contentType = self::contentTypes['updateDraftTableRow'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling updateDraftTableRow'
            );
        }

        // verify the required parameter 'row_id' is set
        if ($row_id === null || (is_array($row_id) && count($row_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $row_id when calling updateDraftTableRow'
            );
        }
        if (!preg_match("/\\d+/", $row_id)) {
            throw new \InvalidArgumentException("invalid value for \"row_id\" when calling RowsApi.updateDraftTableRow, must conform to the pattern /\\d+/.");
        }
        
        // verify the required parameter 'hub_db_table_row_v3_request' is set
        if ($hub_db_table_row_v3_request === null || (is_array($hub_db_table_row_v3_request) && count($hub_db_table_row_v3_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hub_db_table_row_v3_request when calling updateDraftTableRow'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/rows/{rowId}/draft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }
        // path params
        if ($row_id !== null) {
            $resourcePath = str_replace(
                '{' . 'rowId' . '}',
                ObjectSerializer::toPathValue($row_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($hub_db_table_row_v3_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($hub_db_table_row_v3_request));
            } else {
                $httpBody = $hub_db_table_row_v3_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
