<?php
/**
 * TablesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Hubdb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Hubdb
 *
 * HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field.  HubDB tables support `draft` and `published` versions. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed, and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the published version of the data without disrupting it. If a table is set to be `allowed for public access`, you can access the published version of the table and rows without any authentication by specifying the portal id via the query parameter `portalId`.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\Hubdb\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Cms\Hubdb\ApiException;
use HubSpot\Client\Cms\Hubdb\Configuration;
use HubSpot\Client\Cms\Hubdb\HeaderSelector;
use HubSpot\Client\Cms\Hubdb\ObjectSerializer;

/**
 * TablesApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Hubdb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TablesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'archiveTable' => [
            'application/json',
        ],
        'cloneDraftTable' => [
            'application/json',
        ],
        'createTable' => [
            'application/json',
        ],
        'exportDraftTable' => [
            'application/json',
        ],
        'exportTable' => [
            'application/json',
        ],
        'getAllDraftTables' => [
            'application/json',
        ],
        'getAllTables' => [
            'application/json',
        ],
        'getDraftTableDetailsById' => [
            'application/json',
        ],
        'getTableDetails' => [
            'application/json',
        ],
        'importDraftTable' => [
            'multipart/form-data',
        ],
        'publishDraftTable' => [
            'application/json',
        ],
        'resetDraftTable' => [
            'application/json',
        ],
        'unpublishTable' => [
            'application/json',
        ],
        'updateDraftTable' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation archiveTable
     *
     * Archive a table
     *
     * @param  string $table_id_or_name The ID or name of the table to archive. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archiveTable($table_id_or_name, string $contentType = self::contentTypes['archiveTable'][0])
    {
        $this->archiveTableWithHttpInfo($table_id_or_name, $contentType);
    }

    /**
     * Operation archiveTableWithHttpInfo
     *
     * Archive a table
     *
     * @param  string $table_id_or_name The ID or name of the table to archive. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveTableWithHttpInfo($table_id_or_name, string $contentType = self::contentTypes['archiveTable'][0])
    {
        $request = $this->archiveTableRequest($table_id_or_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveTableAsync
     *
     * Archive a table
     *
     * @param  string $table_id_or_name The ID or name of the table to archive. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveTableAsync($table_id_or_name, string $contentType = self::contentTypes['archiveTable'][0])
    {
        return $this->archiveTableAsyncWithHttpInfo($table_id_or_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveTableAsyncWithHttpInfo
     *
     * Archive a table
     *
     * @param  string $table_id_or_name The ID or name of the table to archive. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveTableAsyncWithHttpInfo($table_id_or_name, string $contentType = self::contentTypes['archiveTable'][0])
    {
        $returnType = '';
        $request = $this->archiveTableRequest($table_id_or_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archiveTable'
     *
     * @param  string $table_id_or_name The ID or name of the table to archive. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveTableRequest($table_id_or_name, string $contentType = self::contentTypes['archiveTable'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling archiveTable'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation cloneDraftTable
     *
     * Clone a table
     *
     * @param  string $table_id_or_name The ID or name of the table to clone. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableCloneRequest $hub_db_table_clone_request JSON object with the properties newName and newLabel. You can set copyRows to false to clone the table with copying rows and default is true. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function cloneDraftTable($table_id_or_name, $hub_db_table_clone_request, string $contentType = self::contentTypes['cloneDraftTable'][0])
    {
        list($response) = $this->cloneDraftTableWithHttpInfo($table_id_or_name, $hub_db_table_clone_request, $contentType);
        return $response;
    }

    /**
     * Operation cloneDraftTableWithHttpInfo
     *
     * Clone a table
     *
     * @param  string $table_id_or_name The ID or name of the table to clone. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableCloneRequest $hub_db_table_clone_request JSON object with the properties newName and newLabel. You can set copyRows to false to clone the table with copying rows and default is true. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function cloneDraftTableWithHttpInfo($table_id_or_name, $hub_db_table_clone_request, string $contentType = self::contentTypes['cloneDraftTable'][0])
    {
        $request = $this->cloneDraftTableRequest($table_id_or_name, $hub_db_table_clone_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation cloneDraftTableAsync
     *
     * Clone a table
     *
     * @param  string $table_id_or_name The ID or name of the table to clone. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableCloneRequest $hub_db_table_clone_request JSON object with the properties newName and newLabel. You can set copyRows to false to clone the table with copying rows and default is true. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cloneDraftTableAsync($table_id_or_name, $hub_db_table_clone_request, string $contentType = self::contentTypes['cloneDraftTable'][0])
    {
        return $this->cloneDraftTableAsyncWithHttpInfo($table_id_or_name, $hub_db_table_clone_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation cloneDraftTableAsyncWithHttpInfo
     *
     * Clone a table
     *
     * @param  string $table_id_or_name The ID or name of the table to clone. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableCloneRequest $hub_db_table_clone_request JSON object with the properties newName and newLabel. You can set copyRows to false to clone the table with copying rows and default is true. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cloneDraftTableAsyncWithHttpInfo($table_id_or_name, $hub_db_table_clone_request, string $contentType = self::contentTypes['cloneDraftTable'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
        $request = $this->cloneDraftTableRequest($table_id_or_name, $hub_db_table_clone_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'cloneDraftTable'
     *
     * @param  string $table_id_or_name The ID or name of the table to clone. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableCloneRequest $hub_db_table_clone_request JSON object with the properties newName and newLabel. You can set copyRows to false to clone the table with copying rows and default is true. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['cloneDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function cloneDraftTableRequest($table_id_or_name, $hub_db_table_clone_request, string $contentType = self::contentTypes['cloneDraftTable'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling cloneDraftTable'
            );
        }

        // verify the required parameter 'hub_db_table_clone_request' is set
        if ($hub_db_table_clone_request === null || (is_array($hub_db_table_clone_request) && count($hub_db_table_clone_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hub_db_table_clone_request when calling cloneDraftTable'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/draft/clone';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($hub_db_table_clone_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($hub_db_table_clone_request));
            } else {
                $httpBody = $hub_db_table_clone_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTable
     *
     * Create a new table
     *
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function createTable($hub_db_table_v3_request, string $contentType = self::contentTypes['createTable'][0])
    {
        list($response) = $this->createTableWithHttpInfo($hub_db_table_v3_request, $contentType);
        return $response;
    }

    /**
     * Operation createTableWithHttpInfo
     *
     * Create a new table
     *
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTableWithHttpInfo($hub_db_table_v3_request, string $contentType = self::contentTypes['createTable'][0])
    {
        $request = $this->createTableRequest($hub_db_table_v3_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTableAsync
     *
     * Create a new table
     *
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTableAsync($hub_db_table_v3_request, string $contentType = self::contentTypes['createTable'][0])
    {
        return $this->createTableAsyncWithHttpInfo($hub_db_table_v3_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTableAsyncWithHttpInfo
     *
     * Create a new table
     *
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTableAsyncWithHttpInfo($hub_db_table_v3_request, string $contentType = self::contentTypes['createTable'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
        $request = $this->createTableRequest($hub_db_table_v3_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTable'
     *
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being created. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createTableRequest($hub_db_table_v3_request, string $contentType = self::contentTypes['createTable'][0])
    {

        // verify the required parameter 'hub_db_table_v3_request' is set
        if ($hub_db_table_v3_request === null || (is_array($hub_db_table_v3_request) && count($hub_db_table_v3_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hub_db_table_v3_request when calling createTable'
            );
        }


        $resourcePath = '/cms/v3/hubdb/tables';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($hub_db_table_v3_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($hub_db_table_v3_request));
            } else {
                $httpBody = $hub_db_table_v3_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportDraftTable
     *
     * Export a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \SplFileObject|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function exportDraftTable($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportDraftTable'][0])
    {
        list($response) = $this->exportDraftTableWithHttpInfo($table_id_or_name, $format, $contentType);
        return $response;
    }

    /**
     * Operation exportDraftTableWithHttpInfo
     *
     * Export a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportDraftTableWithHttpInfo($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportDraftTable'][0])
    {
        $request = $this->exportDraftTableRequest($table_id_or_name, $format, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation exportDraftTableAsync
     *
     * Export a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportDraftTableAsync($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportDraftTable'][0])
    {
        return $this->exportDraftTableAsyncWithHttpInfo($table_id_or_name, $format, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportDraftTableAsyncWithHttpInfo
     *
     * Export a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportDraftTableAsyncWithHttpInfo($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportDraftTable'][0])
    {
        $returnType = '\SplFileObject';
        $request = $this->exportDraftTableRequest($table_id_or_name, $format, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportDraftTable'
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportDraftTableRequest($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportDraftTable'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling exportDraftTable'
            );
        }



        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/draft/export';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $format,
            'format', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.ms-excel', 'text/csv', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportTable
     *
     * Export a published version of a table
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \SplFileObject|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function exportTable($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportTable'][0])
    {
        list($response) = $this->exportTableWithHttpInfo($table_id_or_name, $format, $contentType);
        return $response;
    }

    /**
     * Operation exportTableWithHttpInfo
     *
     * Export a published version of a table
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportTableWithHttpInfo($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportTable'][0])
    {
        $request = $this->exportTableRequest($table_id_or_name, $format, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation exportTableAsync
     *
     * Export a published version of a table
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportTableAsync($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportTable'][0])
    {
        return $this->exportTableAsyncWithHttpInfo($table_id_or_name, $format, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportTableAsyncWithHttpInfo
     *
     * Export a published version of a table
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportTableAsyncWithHttpInfo($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportTable'][0])
    {
        $returnType = '\SplFileObject';
        $request = $this->exportTableRequest($table_id_or_name, $format, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportTable'
     *
     * @param  string $table_id_or_name The ID or name of the table to export. (required)
     * @param  string $format The file format to export. Possible values include &#x60;CSV&#x60;, &#x60;XLSX&#x60;, and &#x60;XLS&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportTableRequest($table_id_or_name, $format = null, string $contentType = self::contentTypes['exportTable'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling exportTable'
            );
        }



        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/export';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $format,
            'format', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/vnd.ms-excel', 'text/csv', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllDraftTables
     *
     * Return all draft tables
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllDraftTables'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function getAllDraftTables($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllDraftTables'][0])
    {
        list($response) = $this->getAllDraftTablesWithHttpInfo($sort, $after, $limit, $created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $archived, $contentType);
        return $response;
    }

    /**
     * Operation getAllDraftTablesWithHttpInfo
     *
     * Return all draft tables
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllDraftTables'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllDraftTablesWithHttpInfo($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllDraftTables'][0])
    {
        $request = $this->getAllDraftTablesRequest($sort, $after, $limit, $created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllDraftTablesAsync
     *
     * Return all draft tables
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllDraftTables'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllDraftTablesAsync($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllDraftTables'][0])
    {
        return $this->getAllDraftTablesAsyncWithHttpInfo($sort, $after, $limit, $created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllDraftTablesAsyncWithHttpInfo
     *
     * Return all draft tables
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllDraftTables'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllDraftTablesAsyncWithHttpInfo($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllDraftTables'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging';
        $request = $this->getAllDraftTablesRequest($sort, $after, $limit, $created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllDraftTables'
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllDraftTables'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllDraftTablesRequest($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllDraftTables'][0])
    {












        $resourcePath = '/cms/v3/hubdb/tables/draft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_at,
            'createdAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_after,
            'createdAfter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_before,
            'createdBefore', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_at,
            'updatedAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_after,
            'updatedAfter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_before,
            'updatedBefore', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllTables
     *
     * Get all published tables
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllTables'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function getAllTables($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllTables'][0])
    {
        list($response) = $this->getAllTablesWithHttpInfo($sort, $after, $limit, $created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $archived, $contentType);
        return $response;
    }

    /**
     * Operation getAllTablesWithHttpInfo
     *
     * Get all published tables
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllTables'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllTablesWithHttpInfo($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllTables'][0])
    {
        $request = $this->getAllTablesRequest($sort, $after, $limit, $created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllTablesAsync
     *
     * Get all published tables
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllTables'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllTablesAsync($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllTables'][0])
    {
        return $this->getAllTablesAsyncWithHttpInfo($sort, $after, $limit, $created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllTablesAsyncWithHttpInfo
     *
     * Get all published tables
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllTables'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllTablesAsyncWithHttpInfo($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllTables'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\CollectionResponseWithTotalHubDbTableV3ForwardPaging';
        $request = $this->getAllTablesRequest($sort, $after, $limit, $created_at, $created_after, $created_before, $updated_at, $updated_after, $updated_before, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllTables'
     *
     * @param  string[] $sort Specifies which fields to use for sorting results. Valid fields are &#x60;name&#x60;, &#x60;createdAt&#x60;, &#x60;updatedAt&#x60;, &#x60;createdBy&#x60;, &#x60;updatedBy&#x60;. &#x60;createdAt&#x60; will be used by default. (optional)
     * @param  string $after The cursor token value to get the next set of results. You can get this from the &#x60;paging.next.after&#x60; JSON property of a paged response containing more results. (optional)
     * @param  int $limit The maximum number of results to return. Default is 1000. (optional)
     * @param  \DateTime $created_at Only return tables created at exactly the specified time. (optional)
     * @param  \DateTime $created_after Only return tables created after the specified time. (optional)
     * @param  \DateTime $created_before Only return tables created before the specified time. (optional)
     * @param  \DateTime $updated_at Only return tables last updated at exactly the specified time. (optional)
     * @param  \DateTime $updated_after Only return tables last updated after the specified time. (optional)
     * @param  \DateTime $updated_before Only return tables last updated before the specified time. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllTables'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllTablesRequest($sort = null, $after = null, $limit = null, $created_at = null, $created_after = null, $created_before = null, $updated_at = null, $updated_after = null, $updated_before = null, $archived = null, string $contentType = self::contentTypes['getAllTables'][0])
    {












        $resourcePath = '/cms/v3/hubdb/tables';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort,
            'sort', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_at,
            'createdAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_after,
            'createdAfter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $created_before,
            'createdBefore', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_at,
            'updatedAt', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_after,
            'updatedAfter', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_before,
            'updatedBefore', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDraftTableDetailsById
     *
     * Get details for a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableDetailsById'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function getDraftTableDetailsById($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getDraftTableDetailsById'][0])
    {
        list($response) = $this->getDraftTableDetailsByIdWithHttpInfo($table_id_or_name, $include_foreign_ids, $archived, $contentType);
        return $response;
    }

    /**
     * Operation getDraftTableDetailsByIdWithHttpInfo
     *
     * Get details for a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableDetailsById'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDraftTableDetailsByIdWithHttpInfo($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getDraftTableDetailsById'][0])
    {
        $request = $this->getDraftTableDetailsByIdRequest($table_id_or_name, $include_foreign_ids, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getDraftTableDetailsByIdAsync
     *
     * Get details for a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableDetailsById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDraftTableDetailsByIdAsync($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getDraftTableDetailsById'][0])
    {
        return $this->getDraftTableDetailsByIdAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDraftTableDetailsByIdAsyncWithHttpInfo
     *
     * Get details for a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableDetailsById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDraftTableDetailsByIdAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getDraftTableDetailsById'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
        $request = $this->getDraftTableDetailsByIdRequest($table_id_or_name, $include_foreign_ids, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDraftTableDetailsById'
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDraftTableDetailsById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDraftTableDetailsByIdRequest($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getDraftTableDetailsById'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling getDraftTableDetailsById'
            );
        }




        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/draft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_foreign_ids,
            'includeForeignIds', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTableDetails
     *
     * Get details for a published table
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return details for an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableDetails'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function getTableDetails($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getTableDetails'][0])
    {
        list($response) = $this->getTableDetailsWithHttpInfo($table_id_or_name, $include_foreign_ids, $archived, $contentType);
        return $response;
    }

    /**
     * Operation getTableDetailsWithHttpInfo
     *
     * Get details for a published table
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return details for an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableDetails'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTableDetailsWithHttpInfo($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getTableDetails'][0])
    {
        $request = $this->getTableDetailsRequest($table_id_or_name, $include_foreign_ids, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTableDetailsAsync
     *
     * Get details for a published table
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return details for an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableDetails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTableDetailsAsync($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getTableDetails'][0])
    {
        return $this->getTableDetailsAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTableDetailsAsyncWithHttpInfo
     *
     * Get details for a published table
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return details for an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableDetails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTableDetailsAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getTableDetails'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
        $request = $this->getTableDetailsRequest($table_id_or_name, $include_foreign_ids, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTableDetails'
     *
     * @param  string $table_id_or_name The ID or name of the table to return. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Set this to &#x60;true&#x60; to return details for an archived table. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTableDetails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTableDetailsRequest($table_id_or_name, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['getTableDetails'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling getTableDetails'
            );
        }




        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_foreign_ids,
            'includeForeignIds', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation importDraftTable
     *
     * Import data into draft table
     *
     * @param  string $table_id_or_name The ID of the destination table where data will be imported. (required)
     * @param  string $config Configuration for the import in JSON format as described above. (optional)
     * @param  \SplFileObject $file The source CSV file to be imported. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\ImportResult|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function importDraftTable($table_id_or_name, $config = null, $file = null, string $contentType = self::contentTypes['importDraftTable'][0])
    {
        list($response) = $this->importDraftTableWithHttpInfo($table_id_or_name, $config, $file, $contentType);
        return $response;
    }

    /**
     * Operation importDraftTableWithHttpInfo
     *
     * Import data into draft table
     *
     * @param  string $table_id_or_name The ID of the destination table where data will be imported. (required)
     * @param  string $config Configuration for the import in JSON format as described above. (optional)
     * @param  \SplFileObject $file The source CSV file to be imported. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\ImportResult|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function importDraftTableWithHttpInfo($table_id_or_name, $config = null, $file = null, string $contentType = self::contentTypes['importDraftTable'][0])
    {
        $request = $this->importDraftTableRequest($table_id_or_name, $config, $file, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\ImportResult' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\ImportResult' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\ImportResult', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\ImportResult';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\ImportResult',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation importDraftTableAsync
     *
     * Import data into draft table
     *
     * @param  string $table_id_or_name The ID of the destination table where data will be imported. (required)
     * @param  string $config Configuration for the import in JSON format as described above. (optional)
     * @param  \SplFileObject $file The source CSV file to be imported. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importDraftTableAsync($table_id_or_name, $config = null, $file = null, string $contentType = self::contentTypes['importDraftTable'][0])
    {
        return $this->importDraftTableAsyncWithHttpInfo($table_id_or_name, $config, $file, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation importDraftTableAsyncWithHttpInfo
     *
     * Import data into draft table
     *
     * @param  string $table_id_or_name The ID of the destination table where data will be imported. (required)
     * @param  string $config Configuration for the import in JSON format as described above. (optional)
     * @param  \SplFileObject $file The source CSV file to be imported. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importDraftTableAsyncWithHttpInfo($table_id_or_name, $config = null, $file = null, string $contentType = self::contentTypes['importDraftTable'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\ImportResult';
        $request = $this->importDraftTableRequest($table_id_or_name, $config, $file, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'importDraftTable'
     *
     * @param  string $table_id_or_name The ID of the destination table where data will be imported. (required)
     * @param  string $config Configuration for the import in JSON format as described above. (optional)
     * @param  \SplFileObject $file The source CSV file to be imported. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function importDraftTableRequest($table_id_or_name, $config = null, $file = null, string $contentType = self::contentTypes['importDraftTable'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling importDraftTable'
            );
        }




        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/draft/import';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }

        // form params
        if ($config !== null) {
            $formParams['config'] = ObjectSerializer::toFormValue($config);
        }
        // form params
        if ($file !== null) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation publishDraftTable
     *
     * Publish a table from draft
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function publishDraftTable($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['publishDraftTable'][0])
    {
        list($response) = $this->publishDraftTableWithHttpInfo($table_id_or_name, $include_foreign_ids, $contentType);
        return $response;
    }

    /**
     * Operation publishDraftTableWithHttpInfo
     *
     * Publish a table from draft
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function publishDraftTableWithHttpInfo($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['publishDraftTable'][0])
    {
        $request = $this->publishDraftTableRequest($table_id_or_name, $include_foreign_ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation publishDraftTableAsync
     *
     * Publish a table from draft
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function publishDraftTableAsync($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['publishDraftTable'][0])
    {
        return $this->publishDraftTableAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation publishDraftTableAsyncWithHttpInfo
     *
     * Publish a table from draft
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function publishDraftTableAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['publishDraftTable'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
        $request = $this->publishDraftTableRequest($table_id_or_name, $include_foreign_ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'publishDraftTable'
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function publishDraftTableRequest($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['publishDraftTable'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling publishDraftTable'
            );
        }



        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/draft/publish';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_foreign_ids,
            'includeForeignIds', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation resetDraftTable
     *
     * Reset a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to reset. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resetDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function resetDraftTable($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['resetDraftTable'][0])
    {
        list($response) = $this->resetDraftTableWithHttpInfo($table_id_or_name, $include_foreign_ids, $contentType);
        return $response;
    }

    /**
     * Operation resetDraftTableWithHttpInfo
     *
     * Reset a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to reset. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resetDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function resetDraftTableWithHttpInfo($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['resetDraftTable'][0])
    {
        $request = $this->resetDraftTableRequest($table_id_or_name, $include_foreign_ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation resetDraftTableAsync
     *
     * Reset a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to reset. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resetDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function resetDraftTableAsync($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['resetDraftTable'][0])
    {
        return $this->resetDraftTableAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation resetDraftTableAsyncWithHttpInfo
     *
     * Reset a draft table
     *
     * @param  string $table_id_or_name The ID or name of the table to reset. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resetDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function resetDraftTableAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['resetDraftTable'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
        $request = $this->resetDraftTableRequest($table_id_or_name, $include_foreign_ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'resetDraftTable'
     *
     * @param  string $table_id_or_name The ID or name of the table to reset. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['resetDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function resetDraftTableRequest($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['resetDraftTable'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling resetDraftTable'
            );
        }



        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/draft/reset';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_foreign_ids,
            'includeForeignIds', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation unpublishTable
     *
     * Unpublish a table
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['unpublishTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function unpublishTable($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['unpublishTable'][0])
    {
        list($response) = $this->unpublishTableWithHttpInfo($table_id_or_name, $include_foreign_ids, $contentType);
        return $response;
    }

    /**
     * Operation unpublishTableWithHttpInfo
     *
     * Unpublish a table
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['unpublishTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function unpublishTableWithHttpInfo($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['unpublishTable'][0])
    {
        $request = $this->unpublishTableRequest($table_id_or_name, $include_foreign_ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation unpublishTableAsync
     *
     * Unpublish a table
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['unpublishTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function unpublishTableAsync($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['unpublishTable'][0])
    {
        return $this->unpublishTableAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation unpublishTableAsyncWithHttpInfo
     *
     * Unpublish a table
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['unpublishTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function unpublishTableAsyncWithHttpInfo($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['unpublishTable'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
        $request = $this->unpublishTableRequest($table_id_or_name, $include_foreign_ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'unpublishTable'
     *
     * @param  string $table_id_or_name The ID or name of the table to publish. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the response. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['unpublishTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function unpublishTableRequest($table_id_or_name, $include_foreign_ids = null, string $contentType = self::contentTypes['unpublishTable'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling unpublishTable'
            );
        }



        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/unpublish';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_foreign_ids,
            'includeForeignIds', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateDraftTable
     *
     * Update an existing table
     *
     * @param  string $table_id_or_name The ID or name of the table to update. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being updated. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error
     */
    public function updateDraftTable($table_id_or_name, $hub_db_table_v3_request, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['updateDraftTable'][0])
    {
        list($response) = $this->updateDraftTableWithHttpInfo($table_id_or_name, $hub_db_table_v3_request, $include_foreign_ids, $archived, $contentType);
        return $response;
    }

    /**
     * Operation updateDraftTableWithHttpInfo
     *
     * Update an existing table
     *
     * @param  string $table_id_or_name The ID or name of the table to update. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being updated. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTable'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Cms\Hubdb\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3|\HubSpot\Client\Cms\Hubdb\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDraftTableWithHttpInfo($table_id_or_name, $hub_db_table_v3_request, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['updateDraftTable'][0])
    {
        $request = $this->updateDraftTableRequest($table_id_or_name, $hub_db_table_v3_request, $include_foreign_ids, $archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Cms\Hubdb\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Cms\Hubdb\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Cms\Hubdb\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Cms\Hubdb\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateDraftTableAsync
     *
     * Update an existing table
     *
     * @param  string $table_id_or_name The ID or name of the table to update. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being updated. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDraftTableAsync($table_id_or_name, $hub_db_table_v3_request, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['updateDraftTable'][0])
    {
        return $this->updateDraftTableAsyncWithHttpInfo($table_id_or_name, $hub_db_table_v3_request, $include_foreign_ids, $archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateDraftTableAsyncWithHttpInfo
     *
     * Update an existing table
     *
     * @param  string $table_id_or_name The ID or name of the table to update. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being updated. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDraftTableAsyncWithHttpInfo($table_id_or_name, $hub_db_table_v3_request, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['updateDraftTable'][0])
    {
        $returnType = '\HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3';
        $request = $this->updateDraftTableRequest($table_id_or_name, $hub_db_table_v3_request, $include_foreign_ids, $archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateDraftTable'
     *
     * @param  string $table_id_or_name The ID or name of the table to update. (required)
     * @param  \HubSpot\Client\Cms\Hubdb\Model\HubDbTableV3Request $hub_db_table_v3_request The JSON schema for the table being updated. (required)
     * @param  bool $include_foreign_ids Set this to &#x60;true&#x60; to populate foreign ID values in the result. (optional)
     * @param  bool $archived Specifies whether to return archived tables. Defaults to &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDraftTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateDraftTableRequest($table_id_or_name, $hub_db_table_v3_request, $include_foreign_ids = null, $archived = null, string $contentType = self::contentTypes['updateDraftTable'][0])
    {

        // verify the required parameter 'table_id_or_name' is set
        if ($table_id_or_name === null || (is_array($table_id_or_name) && count($table_id_or_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id_or_name when calling updateDraftTable'
            );
        }

        // verify the required parameter 'hub_db_table_v3_request' is set
        if ($hub_db_table_v3_request === null || (is_array($hub_db_table_v3_request) && count($hub_db_table_v3_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hub_db_table_v3_request when calling updateDraftTable'
            );
        }




        $resourcePath = '/cms/v3/hubdb/tables/{tableIdOrName}/draft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_foreign_ids,
            'includeForeignIds', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $archived,
            'archived', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($table_id_or_name !== null) {
            $resourcePath = str_replace(
                '{' . 'tableIdOrName' . '}',
                ObjectSerializer::toPathValue($table_id_or_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($hub_db_table_v3_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($hub_db_table_v3_request));
            } else {
                $httpBody = $hub_db_table_v3_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
