<?php
/**
 * TimelineEventResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Timeline
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CRM Timeline
 *
 * This feature allows an app to create and configure custom events that can show up in the timelines of certain CRM objects like contacts, companies, tickets, or deals. You'll find multiple use cases for this API in the sections below.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Timeline\Model;

use \ArrayAccess;
use \HubSpot\Client\Crm\Timeline\ObjectSerializer;

/**
 * TimelineEventResponse Class Doc Comment
 *
 * @category Class
 * @description The current state of the timeline event.
 * @package  HubSpot\Client\Crm\Timeline
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TimelineEventResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TimelineEventResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'event_template_id' => 'string',
        'created_at' => '\DateTime',
        'extra_data' => 'object',
        'timeline_i_frame' => '\HubSpot\Client\Crm\Timeline\Model\TimelineEventIFrame',
        'domain' => 'string',
        'tokens' => 'array<string,string>',
        'id' => 'string',
        'utk' => 'string',
        'email' => 'string',
        'object_id' => 'string',
        'timestamp' => '\DateTime',
        'object_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'event_template_id' => null,
        'created_at' => 'date-time',
        'extra_data' => null,
        'timeline_i_frame' => null,
        'domain' => null,
        'tokens' => null,
        'id' => null,
        'utk' => null,
        'email' => null,
        'object_id' => null,
        'timestamp' => 'date-time',
        'object_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'event_template_id' => false,
        'created_at' => false,
        'extra_data' => false,
        'timeline_i_frame' => false,
        'domain' => false,
        'tokens' => false,
        'id' => false,
        'utk' => false,
        'email' => false,
        'object_id' => false,
        'timestamp' => false,
        'object_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'event_template_id' => 'eventTemplateId',
        'created_at' => 'createdAt',
        'extra_data' => 'extraData',
        'timeline_i_frame' => 'timelineIFrame',
        'domain' => 'domain',
        'tokens' => 'tokens',
        'id' => 'id',
        'utk' => 'utk',
        'email' => 'email',
        'object_id' => 'objectId',
        'timestamp' => 'timestamp',
        'object_type' => 'objectType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'event_template_id' => 'setEventTemplateId',
        'created_at' => 'setCreatedAt',
        'extra_data' => 'setExtraData',
        'timeline_i_frame' => 'setTimelineIFrame',
        'domain' => 'setDomain',
        'tokens' => 'setTokens',
        'id' => 'setId',
        'utk' => 'setUtk',
        'email' => 'setEmail',
        'object_id' => 'setObjectId',
        'timestamp' => 'setTimestamp',
        'object_type' => 'setObjectType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'event_template_id' => 'getEventTemplateId',
        'created_at' => 'getCreatedAt',
        'extra_data' => 'getExtraData',
        'timeline_i_frame' => 'getTimelineIFrame',
        'domain' => 'getDomain',
        'tokens' => 'getTokens',
        'id' => 'getId',
        'utk' => 'getUtk',
        'email' => 'getEmail',
        'object_id' => 'getObjectId',
        'timestamp' => 'getTimestamp',
        'object_type' => 'getObjectType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('event_template_id', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('extra_data', $data ?? [], null);
        $this->setIfExists('timeline_i_frame', $data ?? [], null);
        $this->setIfExists('domain', $data ?? [], null);
        $this->setIfExists('tokens', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('utk', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('object_id', $data ?? [], null);
        $this->setIfExists('timestamp', $data ?? [], null);
        $this->setIfExists('object_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['event_template_id'] === null) {
            $invalidProperties[] = "'event_template_id' can't be null";
        }
        if ($this->container['tokens'] === null) {
            $invalidProperties[] = "'tokens' can't be null";
        }
        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['object_type'] === null) {
            $invalidProperties[] = "'object_type' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets event_template_id
     *
     * @return string
     */
    public function getEventTemplateId()
    {
        return $this->container['event_template_id'];
    }

    /**
     * Sets event_template_id
     *
     * @param string $event_template_id The event template ID.
     *
     * @return self
     */
    public function setEventTemplateId($event_template_id)
    {
        if (is_null($event_template_id)) {
            throw new \InvalidArgumentException('non-nullable event_template_id cannot be null');
        }
        $this->container['event_template_id'] = $event_template_id;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at created_at
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets extra_data
     *
     * @return object|null
     */
    public function getExtraData()
    {
        return $this->container['extra_data'];
    }

    /**
     * Sets extra_data
     *
     * @param object|null $extra_data Additional event-specific data that can be interpreted by the template's markdown.
     *
     * @return self
     */
    public function setExtraData($extra_data)
    {
        if (is_null($extra_data)) {
            throw new \InvalidArgumentException('non-nullable extra_data cannot be null');
        }
        $this->container['extra_data'] = $extra_data;

        return $this;
    }

    /**
     * Gets timeline_i_frame
     *
     * @return \HubSpot\Client\Crm\Timeline\Model\TimelineEventIFrame|null
     */
    public function getTimelineIFrame()
    {
        return $this->container['timeline_i_frame'];
    }

    /**
     * Sets timeline_i_frame
     *
     * @param \HubSpot\Client\Crm\Timeline\Model\TimelineEventIFrame|null $timeline_i_frame timeline_i_frame
     *
     * @return self
     */
    public function setTimelineIFrame($timeline_i_frame)
    {
        if (is_null($timeline_i_frame)) {
            throw new \InvalidArgumentException('non-nullable timeline_i_frame cannot be null');
        }
        $this->container['timeline_i_frame'] = $timeline_i_frame;

        return $this;
    }

    /**
     * Gets domain
     *
     * @return string|null
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     *
     * @param string|null $domain The event domain (often paired with utk).
     *
     * @return self
     */
    public function setDomain($domain)
    {
        if (is_null($domain)) {
            throw new \InvalidArgumentException('non-nullable domain cannot be null');
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets tokens
     *
     * @return array<string,string>
     */
    public function getTokens()
    {
        return $this->container['tokens'];
    }

    /**
     * Sets tokens
     *
     * @param array<string,string> $tokens A collection of token keys and values associated with the template tokens.
     *
     * @return self
     */
    public function setTokens($tokens)
    {
        if (is_null($tokens)) {
            throw new \InvalidArgumentException('non-nullable tokens cannot be null');
        }
        $this->container['tokens'] = $tokens;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id Identifier for the event. This should be unique to the app and event template. If you use the same ID for different CRM objects, the last to be processed will win and the first will not have a record. You can also use `{{uuid}}` anywhere in the ID to generate a unique string, guaranteeing uniqueness.
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets utk
     *
     * @return string|null
     */
    public function getUtk()
    {
        return $this->container['utk'];
    }

    /**
     * Sets utk
     *
     * @param string|null $utk Use the `utk` parameter to associate an event with a contact by `usertoken`. This is recommended if you don't know a user's email, but have an identifying user token in your cookie.
     *
     * @return self
     */
    public function setUtk($utk)
    {
        if (is_null($utk)) {
            throw new \InvalidArgumentException('non-nullable utk cannot be null');
        }
        $this->container['utk'] = $utk;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email The email address used for contact-specific events. This can be used to identify existing contacts, create new ones, or change the email for an existing contact (if paired with the `objectId`).
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets object_id
     *
     * @return string|null
     */
    public function getObjectId()
    {
        return $this->container['object_id'];
    }

    /**
     * Sets object_id
     *
     * @param string|null $object_id The CRM object identifier. This is required for every event other than contacts (where utk or email can be used).
     *
     * @return self
     */
    public function setObjectId($object_id)
    {
        if (is_null($object_id)) {
            throw new \InvalidArgumentException('non-nullable object_id cannot be null');
        }
        $this->container['object_id'] = $object_id;

        return $this;
    }

    /**
     * Gets timestamp
     *
     * @return \DateTime|null
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     *
     * @param \DateTime|null $timestamp The time the event occurred. If not passed in, the curren time will be assumed. This is used to determine where an event is shown on a CRM object's timeline.
     *
     * @return self
     */
    public function setTimestamp($timestamp)
    {
        if (is_null($timestamp)) {
            throw new \InvalidArgumentException('non-nullable timestamp cannot be null');
        }
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets object_type
     *
     * @return string
     */
    public function getObjectType()
    {
        return $this->container['object_type'];
    }

    /**
     * Sets object_type
     *
     * @param string $object_type The ObjectType associated with the EventTemplate.
     *
     * @return self
     */
    public function setObjectType($object_type)
    {
        if (is_null($object_type)) {
            throw new \InvalidArgumentException('non-nullable object_type cannot be null');
        }
        $this->container['object_type'] = $object_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


