<?php
/**
 * PropertyValue
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Events
 *
 * These APIs allow you to interact with HubSpot's Marketing Events Extension. It allows you to: * Create, Read or update Marketing Event information in HubSpot * Specify whether a HubSpot contact has registered, attended or cancelled a registration to a Marketing Event. * Specify a URL that can be called to get the details of a Marketing Event.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Events\Model;

use \ArrayAccess;
use \HubSpot\Client\Marketing\Events\ObjectSerializer;

/**
 * PropertyValue Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PropertyValue implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PropertyValue';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'source_id' => 'string',
        'selected_by_user' => 'bool',
        'source_label' => 'string',
        'source' => 'string',
        'updated_by_user_id' => 'int',
        'persistence_timestamp' => 'int',
        'source_metadata' => 'string',
        'source_vid' => 'int[]',
        'request_id' => 'string',
        'name' => 'string',
        'use_timestamp_as_persistence_timestamp' => 'bool',
        'value' => 'string',
        'selected_by_user_timestamp' => 'int',
        'timestamp' => 'int',
        'is_large_value' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'source_id' => null,
        'selected_by_user' => null,
        'source_label' => null,
        'source' => null,
        'updated_by_user_id' => 'int32',
        'persistence_timestamp' => 'int64',
        'source_metadata' => null,
        'source_vid' => 'int64',
        'request_id' => null,
        'name' => null,
        'use_timestamp_as_persistence_timestamp' => null,
        'value' => null,
        'selected_by_user_timestamp' => 'int64',
        'timestamp' => 'int64',
        'is_large_value' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'source_id' => false,
        'selected_by_user' => false,
        'source_label' => false,
        'source' => false,
        'updated_by_user_id' => false,
        'persistence_timestamp' => false,
        'source_metadata' => false,
        'source_vid' => false,
        'request_id' => false,
        'name' => false,
        'use_timestamp_as_persistence_timestamp' => false,
        'value' => false,
        'selected_by_user_timestamp' => false,
        'timestamp' => false,
        'is_large_value' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'source_id' => 'sourceId',
        'selected_by_user' => 'selectedByUser',
        'source_label' => 'sourceLabel',
        'source' => 'source',
        'updated_by_user_id' => 'updatedByUserId',
        'persistence_timestamp' => 'persistenceTimestamp',
        'source_metadata' => 'sourceMetadata',
        'source_vid' => 'sourceVid',
        'request_id' => 'requestId',
        'name' => 'name',
        'use_timestamp_as_persistence_timestamp' => 'useTimestampAsPersistenceTimestamp',
        'value' => 'value',
        'selected_by_user_timestamp' => 'selectedByUserTimestamp',
        'timestamp' => 'timestamp',
        'is_large_value' => 'isLargeValue'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'source_id' => 'setSourceId',
        'selected_by_user' => 'setSelectedByUser',
        'source_label' => 'setSourceLabel',
        'source' => 'setSource',
        'updated_by_user_id' => 'setUpdatedByUserId',
        'persistence_timestamp' => 'setPersistenceTimestamp',
        'source_metadata' => 'setSourceMetadata',
        'source_vid' => 'setSourceVid',
        'request_id' => 'setRequestId',
        'name' => 'setName',
        'use_timestamp_as_persistence_timestamp' => 'setUseTimestampAsPersistenceTimestamp',
        'value' => 'setValue',
        'selected_by_user_timestamp' => 'setSelectedByUserTimestamp',
        'timestamp' => 'setTimestamp',
        'is_large_value' => 'setIsLargeValue'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'source_id' => 'getSourceId',
        'selected_by_user' => 'getSelectedByUser',
        'source_label' => 'getSourceLabel',
        'source' => 'getSource',
        'updated_by_user_id' => 'getUpdatedByUserId',
        'persistence_timestamp' => 'getPersistenceTimestamp',
        'source_metadata' => 'getSourceMetadata',
        'source_vid' => 'getSourceVid',
        'request_id' => 'getRequestId',
        'name' => 'getName',
        'use_timestamp_as_persistence_timestamp' => 'getUseTimestampAsPersistenceTimestamp',
        'value' => 'getValue',
        'selected_by_user_timestamp' => 'getSelectedByUserTimestamp',
        'timestamp' => 'getTimestamp',
        'is_large_value' => 'getIsLargeValue'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const SOURCE_IMPORT = 'IMPORT';
    public const SOURCE_API = 'API';
    public const SOURCE_FORM = 'FORM';
    public const SOURCE_ANALYTICS = 'ANALYTICS';
    public const SOURCE_MIGRATION = 'MIGRATION';
    public const SOURCE_SALESFORCE = 'SALESFORCE';
    public const SOURCE_INTEGRATION = 'INTEGRATION';
    public const SOURCE_CONTACTS_WEB = 'CONTACTS_WEB';
    public const SOURCE_WAL_INCREMENTAL = 'WAL_INCREMENTAL';
    public const SOURCE_TASK = 'TASK';
    public const SOURCE_EMAIL = 'EMAIL';
    public const SOURCE_WORKFLOWS = 'WORKFLOWS';
    public const SOURCE_CALCULATED = 'CALCULATED';
    public const SOURCE_SOCIAL = 'SOCIAL';
    public const SOURCE_BATCH_UPDATE = 'BATCH_UPDATE';
    public const SOURCE_SIGNALS = 'SIGNALS';
    public const SOURCE_BIDEN = 'BIDEN';
    public const SOURCE__DEFAULT = 'DEFAULT';
    public const SOURCE_COMPANIES = 'COMPANIES';
    public const SOURCE_DEALS = 'DEALS';
    public const SOURCE_ASSISTS = 'ASSISTS';
    public const SOURCE_PRESENTATIONS = 'PRESENTATIONS';
    public const SOURCE_TALLY = 'TALLY';
    public const SOURCE_SIDEKICK = 'SIDEKICK';
    public const SOURCE_CRM_UI = 'CRM_UI';
    public const SOURCE_MERGE_CONTACTS = 'MERGE_CONTACTS';
    public const SOURCE_PORTAL_USER_ASSOCIATOR = 'PORTAL_USER_ASSOCIATOR';
    public const SOURCE_INTEGRATIONS_PLATFORM = 'INTEGRATIONS_PLATFORM';
    public const SOURCE_BCC_TO_CRM = 'BCC_TO_CRM';
    public const SOURCE_FORWARD_TO_CRM = 'FORWARD_TO_CRM';
    public const SOURCE_ENGAGEMENTS = 'ENGAGEMENTS';
    public const SOURCE_SALES = 'SALES';
    public const SOURCE_HEISENBERG = 'HEISENBERG';
    public const SOURCE_LEADIN = 'LEADIN';
    public const SOURCE_GMAIL_INTEGRATION = 'GMAIL_INTEGRATION';
    public const SOURCE_ACADEMY = 'ACADEMY';
    public const SOURCE_SALES_MESSAGES = 'SALES_MESSAGES';
    public const SOURCE_AVATARS_SERVICE = 'AVATARS_SERVICE';
    public const SOURCE_MERGE_COMPANIES = 'MERGE_COMPANIES';
    public const SOURCE_SEQUENCES = 'SEQUENCES';
    public const SOURCE_COMPANY_FAMILIES = 'COMPANY_FAMILIES';
    public const SOURCE_MOBILE_IOS = 'MOBILE_IOS';
    public const SOURCE_MOBILE_ANDROID = 'MOBILE_ANDROID';
    public const SOURCE_CONTACTS = 'CONTACTS';
    public const SOURCE_ASSOCIATIONS = 'ASSOCIATIONS';
    public const SOURCE_EXTENSION = 'EXTENSION';
    public const SOURCE_SUCCESS = 'SUCCESS';
    public const SOURCE_BOT = 'BOT';
    public const SOURCE_INTEGRATIONS_SYNC = 'INTEGRATIONS_SYNC';
    public const SOURCE_AUTOMATION_PLATFORM = 'AUTOMATION_PLATFORM';
    public const SOURCE_CONVERSATIONS = 'CONVERSATIONS';
    public const SOURCE_EMAIL_INTEGRATION = 'EMAIL_INTEGRATION';
    public const SOURCE_CONTENT_MEMBERSHIP = 'CONTENT_MEMBERSHIP';
    public const SOURCE_QUOTES = 'QUOTES';
    public const SOURCE_BET_ASSIGNMENT = 'BET_ASSIGNMENT';
    public const SOURCE_QUOTAS = 'QUOTAS';
    public const SOURCE_BET_CRM_CONNECTOR = 'BET_CRM_CONNECTOR';
    public const SOURCE_MEETINGS = 'MEETINGS';
    public const SOURCE_MERGE_OBJECTS = 'MERGE_OBJECTS';
    public const SOURCE_RECYCLING_BIN = 'RECYCLING_BIN';
    public const SOURCE_ADS = 'ADS';
    public const SOURCE_AI_GROUP = 'AI_GROUP';
    public const SOURCE_COMMUNICATOR = 'COMMUNICATOR';
    public const SOURCE_SETTINGS = 'SETTINGS';
    public const SOURCE_PROPERTY_SETTINGS = 'PROPERTY_SETTINGS';
    public const SOURCE_PIPELINE_SETTINGS = 'PIPELINE_SETTINGS';
    public const SOURCE_COMPANY_INSIGHTS = 'COMPANY_INSIGHTS';
    public const SOURCE_BEHAVIORAL_EVENTS = 'BEHAVIORAL_EVENTS';
    public const SOURCE_PAYMENTS = 'PAYMENTS';
    public const SOURCE_GOALS = 'GOALS';
    public const SOURCE_PORTAL_OBJECT_SYNC = 'PORTAL_OBJECT_SYNC';
    public const SOURCE_APPROVALS = 'APPROVALS';
    public const SOURCE_FILE_MANAGER = 'FILE_MANAGER';
    public const SOURCE_MARKETPLACE = 'MARKETPLACE';
    public const SOURCE_INTERNAL_PROCESSING = 'INTERNAL_PROCESSING';
    public const SOURCE_FORECASTING = 'FORECASTING';
    public const SOURCE_SLACK_INTEGRATION = 'SLACK_INTEGRATION';
    public const SOURCE_CRM_UI_BULK_ACTION = 'CRM_UI_BULK_ACTION';
    public const SOURCE_WORKFLOW_CONTACT_DELETE_ACTION = 'WORKFLOW_CONTACT_DELETE_ACTION';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSourceAllowableValues()
    {
        return [
            self::SOURCE_IMPORT,
            self::SOURCE_API,
            self::SOURCE_FORM,
            self::SOURCE_ANALYTICS,
            self::SOURCE_MIGRATION,
            self::SOURCE_SALESFORCE,
            self::SOURCE_INTEGRATION,
            self::SOURCE_CONTACTS_WEB,
            self::SOURCE_WAL_INCREMENTAL,
            self::SOURCE_TASK,
            self::SOURCE_EMAIL,
            self::SOURCE_WORKFLOWS,
            self::SOURCE_CALCULATED,
            self::SOURCE_SOCIAL,
            self::SOURCE_BATCH_UPDATE,
            self::SOURCE_SIGNALS,
            self::SOURCE_BIDEN,
            self::SOURCE__DEFAULT,
            self::SOURCE_COMPANIES,
            self::SOURCE_DEALS,
            self::SOURCE_ASSISTS,
            self::SOURCE_PRESENTATIONS,
            self::SOURCE_TALLY,
            self::SOURCE_SIDEKICK,
            self::SOURCE_CRM_UI,
            self::SOURCE_MERGE_CONTACTS,
            self::SOURCE_PORTAL_USER_ASSOCIATOR,
            self::SOURCE_INTEGRATIONS_PLATFORM,
            self::SOURCE_BCC_TO_CRM,
            self::SOURCE_FORWARD_TO_CRM,
            self::SOURCE_ENGAGEMENTS,
            self::SOURCE_SALES,
            self::SOURCE_HEISENBERG,
            self::SOURCE_LEADIN,
            self::SOURCE_GMAIL_INTEGRATION,
            self::SOURCE_ACADEMY,
            self::SOURCE_SALES_MESSAGES,
            self::SOURCE_AVATARS_SERVICE,
            self::SOURCE_MERGE_COMPANIES,
            self::SOURCE_SEQUENCES,
            self::SOURCE_COMPANY_FAMILIES,
            self::SOURCE_MOBILE_IOS,
            self::SOURCE_MOBILE_ANDROID,
            self::SOURCE_CONTACTS,
            self::SOURCE_ASSOCIATIONS,
            self::SOURCE_EXTENSION,
            self::SOURCE_SUCCESS,
            self::SOURCE_BOT,
            self::SOURCE_INTEGRATIONS_SYNC,
            self::SOURCE_AUTOMATION_PLATFORM,
            self::SOURCE_CONVERSATIONS,
            self::SOURCE_EMAIL_INTEGRATION,
            self::SOURCE_CONTENT_MEMBERSHIP,
            self::SOURCE_QUOTES,
            self::SOURCE_BET_ASSIGNMENT,
            self::SOURCE_QUOTAS,
            self::SOURCE_BET_CRM_CONNECTOR,
            self::SOURCE_MEETINGS,
            self::SOURCE_MERGE_OBJECTS,
            self::SOURCE_RECYCLING_BIN,
            self::SOURCE_ADS,
            self::SOURCE_AI_GROUP,
            self::SOURCE_COMMUNICATOR,
            self::SOURCE_SETTINGS,
            self::SOURCE_PROPERTY_SETTINGS,
            self::SOURCE_PIPELINE_SETTINGS,
            self::SOURCE_COMPANY_INSIGHTS,
            self::SOURCE_BEHAVIORAL_EVENTS,
            self::SOURCE_PAYMENTS,
            self::SOURCE_GOALS,
            self::SOURCE_PORTAL_OBJECT_SYNC,
            self::SOURCE_APPROVALS,
            self::SOURCE_FILE_MANAGER,
            self::SOURCE_MARKETPLACE,
            self::SOURCE_INTERNAL_PROCESSING,
            self::SOURCE_FORECASTING,
            self::SOURCE_SLACK_INTEGRATION,
            self::SOURCE_CRM_UI_BULK_ACTION,
            self::SOURCE_WORKFLOW_CONTACT_DELETE_ACTION,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('source_id', $data ?? [], null);
        $this->setIfExists('selected_by_user', $data ?? [], null);
        $this->setIfExists('source_label', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('updated_by_user_id', $data ?? [], null);
        $this->setIfExists('persistence_timestamp', $data ?? [], null);
        $this->setIfExists('source_metadata', $data ?? [], null);
        $this->setIfExists('source_vid', $data ?? [], null);
        $this->setIfExists('request_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('use_timestamp_as_persistence_timestamp', $data ?? [], null);
        $this->setIfExists('value', $data ?? [], null);
        $this->setIfExists('selected_by_user_timestamp', $data ?? [], null);
        $this->setIfExists('timestamp', $data ?? [], null);
        $this->setIfExists('is_large_value', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['source_id'] === null) {
            $invalidProperties[] = "'source_id' can't be null";
        }
        if ($this->container['selected_by_user'] === null) {
            $invalidProperties[] = "'selected_by_user' can't be null";
        }
        if ($this->container['source_label'] === null) {
            $invalidProperties[] = "'source_label' can't be null";
        }
        if ($this->container['source'] === null) {
            $invalidProperties[] = "'source' can't be null";
        }
        $allowedValues = $this->getSourceAllowableValues();
        if (!is_null($this->container['source']) && !in_array($this->container['source'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'source', must be one of '%s'",
                $this->container['source'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['source_metadata'] === null) {
            $invalidProperties[] = "'source_metadata' can't be null";
        }
        if ($this->container['source_vid'] === null) {
            $invalidProperties[] = "'source_vid' can't be null";
        }
        if ($this->container['request_id'] === null) {
            $invalidProperties[] = "'request_id' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['value'] === null) {
            $invalidProperties[] = "'value' can't be null";
        }
        if ($this->container['selected_by_user_timestamp'] === null) {
            $invalidProperties[] = "'selected_by_user_timestamp' can't be null";
        }
        if ($this->container['timestamp'] === null) {
            $invalidProperties[] = "'timestamp' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets source_id
     *
     * @return string
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string $source_id 
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        if (is_null($source_id)) {
            throw new \InvalidArgumentException('non-nullable source_id cannot be null');
        }
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets selected_by_user
     *
     * @return bool
     */
    public function getSelectedByUser()
    {
        return $this->container['selected_by_user'];
    }

    /**
     * Sets selected_by_user
     *
     * @param bool $selected_by_user 
     *
     * @return self
     */
    public function setSelectedByUser($selected_by_user)
    {
        if (is_null($selected_by_user)) {
            throw new \InvalidArgumentException('non-nullable selected_by_user cannot be null');
        }
        $this->container['selected_by_user'] = $selected_by_user;

        return $this;
    }

    /**
     * Gets source_label
     *
     * @return string
     */
    public function getSourceLabel()
    {
        return $this->container['source_label'];
    }

    /**
     * Sets source_label
     *
     * @param string $source_label 
     *
     * @return self
     */
    public function setSourceLabel($source_label)
    {
        if (is_null($source_label)) {
            throw new \InvalidArgumentException('non-nullable source_label cannot be null');
        }
        $this->container['source_label'] = $source_label;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string $source 
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $allowedValues = $this->getSourceAllowableValues();
        if (!in_array($source, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'source', must be one of '%s'",
                    $source,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets updated_by_user_id
     *
     * @return int|null
     */
    public function getUpdatedByUserId()
    {
        return $this->container['updated_by_user_id'];
    }

    /**
     * Sets updated_by_user_id
     *
     * @param int|null $updated_by_user_id updated_by_user_id
     *
     * @return self
     */
    public function setUpdatedByUserId($updated_by_user_id)
    {
        if (is_null($updated_by_user_id)) {
            throw new \InvalidArgumentException('non-nullable updated_by_user_id cannot be null');
        }
        $this->container['updated_by_user_id'] = $updated_by_user_id;

        return $this;
    }

    /**
     * Gets persistence_timestamp
     *
     * @return int|null
     */
    public function getPersistenceTimestamp()
    {
        return $this->container['persistence_timestamp'];
    }

    /**
     * Sets persistence_timestamp
     *
     * @param int|null $persistence_timestamp persistence_timestamp
     *
     * @return self
     */
    public function setPersistenceTimestamp($persistence_timestamp)
    {
        if (is_null($persistence_timestamp)) {
            throw new \InvalidArgumentException('non-nullable persistence_timestamp cannot be null');
        }
        $this->container['persistence_timestamp'] = $persistence_timestamp;

        return $this;
    }

    /**
     * Gets source_metadata
     *
     * @return string
     */
    public function getSourceMetadata()
    {
        return $this->container['source_metadata'];
    }

    /**
     * Sets source_metadata
     *
     * @param string $source_metadata Source metadata encoded as a base64 string. For example: `ZXhhbXBsZSBzdHJpbmc=`
     *
     * @return self
     */
    public function setSourceMetadata($source_metadata)
    {
        if (is_null($source_metadata)) {
            throw new \InvalidArgumentException('non-nullable source_metadata cannot be null');
        }
        $this->container['source_metadata'] = $source_metadata;

        return $this;
    }

    /**
     * Gets source_vid
     *
     * @return int[]
     */
    public function getSourceVid()
    {
        return $this->container['source_vid'];
    }

    /**
     * Sets source_vid
     *
     * @param int[] $source_vid 
     *
     * @return self
     */
    public function setSourceVid($source_vid)
    {
        if (is_null($source_vid)) {
            throw new \InvalidArgumentException('non-nullable source_vid cannot be null');
        }
        $this->container['source_vid'] = $source_vid;

        return $this;
    }

    /**
     * Gets request_id
     *
     * @return string
     */
    public function getRequestId()
    {
        return $this->container['request_id'];
    }

    /**
     * Sets request_id
     *
     * @param string $request_id 
     *
     * @return self
     */
    public function setRequestId($request_id)
    {
        if (is_null($request_id)) {
            throw new \InvalidArgumentException('non-nullable request_id cannot be null');
        }
        $this->container['request_id'] = $request_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name 
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets use_timestamp_as_persistence_timestamp
     *
     * @return bool|null
     */
    public function getUseTimestampAsPersistenceTimestamp()
    {
        return $this->container['use_timestamp_as_persistence_timestamp'];
    }

    /**
     * Sets use_timestamp_as_persistence_timestamp
     *
     * @param bool|null $use_timestamp_as_persistence_timestamp use_timestamp_as_persistence_timestamp
     *
     * @return self
     */
    public function setUseTimestampAsPersistenceTimestamp($use_timestamp_as_persistence_timestamp)
    {
        if (is_null($use_timestamp_as_persistence_timestamp)) {
            throw new \InvalidArgumentException('non-nullable use_timestamp_as_persistence_timestamp cannot be null');
        }
        $this->container['use_timestamp_as_persistence_timestamp'] = $use_timestamp_as_persistence_timestamp;

        return $this;
    }

    /**
     * Gets value
     *
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param string $value 
     *
     * @return self
     */
    public function setValue($value)
    {
        if (is_null($value)) {
            throw new \InvalidArgumentException('non-nullable value cannot be null');
        }
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets selected_by_user_timestamp
     *
     * @return int
     */
    public function getSelectedByUserTimestamp()
    {
        return $this->container['selected_by_user_timestamp'];
    }

    /**
     * Sets selected_by_user_timestamp
     *
     * @param int $selected_by_user_timestamp 
     *
     * @return self
     */
    public function setSelectedByUserTimestamp($selected_by_user_timestamp)
    {
        if (is_null($selected_by_user_timestamp)) {
            throw new \InvalidArgumentException('non-nullable selected_by_user_timestamp cannot be null');
        }
        $this->container['selected_by_user_timestamp'] = $selected_by_user_timestamp;

        return $this;
    }

    /**
     * Gets timestamp
     *
     * @return int
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     *
     * @param int $timestamp 
     *
     * @return self
     */
    public function setTimestamp($timestamp)
    {
        if (is_null($timestamp)) {
            throw new \InvalidArgumentException('non-nullable timestamp cannot be null');
        }
        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets is_large_value
     *
     * @return bool|null
     */
    public function getIsLargeValue()
    {
        return $this->container['is_large_value'];
    }

    /**
     * Sets is_large_value
     *
     * @param bool|null $is_large_value is_large_value
     *
     * @return self
     */
    public function setIsLargeValue($is_large_value)
    {
        if (is_null($is_large_value)) {
            throw new \InvalidArgumentException('non-nullable is_large_value cannot be null');
        }
        $this->container['is_large_value'] = $is_large_value;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


