<?php
/**
 * PublicUser
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Settings\Users
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Settings User Provisioning
 *
 * Add, manage, and remove users from your account
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Settings\Users\Model;

use \ArrayAccess;
use \HubSpot\Client\Settings\Users\ObjectSerializer;

/**
 * PublicUser Class Doc Comment
 *
 * @category Class
 * @description A user
 * @package  HubSpot\Client\Settings\Users
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PublicUser implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PublicUser';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'primary_team_id' => 'string',
        'role_ids' => 'string[]',
        'send_welcome_email' => 'bool',
        'role_id' => 'string',
        'secondary_team_ids' => 'string[]',
        'id' => 'string',
        'super_admin' => 'bool',
        'email' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'primary_team_id' => null,
        'role_ids' => null,
        'send_welcome_email' => null,
        'role_id' => null,
        'secondary_team_ids' => null,
        'id' => null,
        'super_admin' => null,
        'email' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'primary_team_id' => false,
        'role_ids' => false,
        'send_welcome_email' => false,
        'role_id' => false,
        'secondary_team_ids' => false,
        'id' => false,
        'super_admin' => false,
        'email' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'primary_team_id' => 'primaryTeamId',
        'role_ids' => 'roleIds',
        'send_welcome_email' => 'sendWelcomeEmail',
        'role_id' => 'roleId',
        'secondary_team_ids' => 'secondaryTeamIds',
        'id' => 'id',
        'super_admin' => 'superAdmin',
        'email' => 'email'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'primary_team_id' => 'setPrimaryTeamId',
        'role_ids' => 'setRoleIds',
        'send_welcome_email' => 'setSendWelcomeEmail',
        'role_id' => 'setRoleId',
        'secondary_team_ids' => 'setSecondaryTeamIds',
        'id' => 'setId',
        'super_admin' => 'setSuperAdmin',
        'email' => 'setEmail'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'primary_team_id' => 'getPrimaryTeamId',
        'role_ids' => 'getRoleIds',
        'send_welcome_email' => 'getSendWelcomeEmail',
        'role_id' => 'getRoleId',
        'secondary_team_ids' => 'getSecondaryTeamIds',
        'id' => 'getId',
        'super_admin' => 'getSuperAdmin',
        'email' => 'getEmail'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('primary_team_id', $data ?? [], null);
        $this->setIfExists('role_ids', $data ?? [], null);
        $this->setIfExists('send_welcome_email', $data ?? [], null);
        $this->setIfExists('role_id', $data ?? [], null);
        $this->setIfExists('secondary_team_ids', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('super_admin', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['email'] === null) {
            $invalidProperties[] = "'email' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets primary_team_id
     *
     * @return string|null
     */
    public function getPrimaryTeamId()
    {
        return $this->container['primary_team_id'];
    }

    /**
     * Sets primary_team_id
     *
     * @param string|null $primary_team_id The user's primary team
     *
     * @return self
     */
    public function setPrimaryTeamId($primary_team_id)
    {
        if (is_null($primary_team_id)) {
            throw new \InvalidArgumentException('non-nullable primary_team_id cannot be null');
        }
        $this->container['primary_team_id'] = $primary_team_id;

        return $this;
    }

    /**
     * Gets role_ids
     *
     * @return string[]|null
     */
    public function getRoleIds()
    {
        return $this->container['role_ids'];
    }

    /**
     * Sets role_ids
     *
     * @param string[]|null $role_ids role_ids
     *
     * @return self
     */
    public function setRoleIds($role_ids)
    {
        if (is_null($role_ids)) {
            throw new \InvalidArgumentException('non-nullable role_ids cannot be null');
        }
        $this->container['role_ids'] = $role_ids;

        return $this;
    }

    /**
     * Gets send_welcome_email
     *
     * @return bool|null
     */
    public function getSendWelcomeEmail()
    {
        return $this->container['send_welcome_email'];
    }

    /**
     * Sets send_welcome_email
     *
     * @param bool|null $send_welcome_email send_welcome_email
     *
     * @return self
     */
    public function setSendWelcomeEmail($send_welcome_email)
    {
        if (is_null($send_welcome_email)) {
            throw new \InvalidArgumentException('non-nullable send_welcome_email cannot be null');
        }
        $this->container['send_welcome_email'] = $send_welcome_email;

        return $this;
    }

    /**
     * Gets role_id
     *
     * @return string|null
     */
    public function getRoleId()
    {
        return $this->container['role_id'];
    }

    /**
     * Sets role_id
     *
     * @param string|null $role_id The user's role
     *
     * @return self
     */
    public function setRoleId($role_id)
    {
        if (is_null($role_id)) {
            throw new \InvalidArgumentException('non-nullable role_id cannot be null');
        }
        $this->container['role_id'] = $role_id;

        return $this;
    }

    /**
     * Gets secondary_team_ids
     *
     * @return string[]|null
     */
    public function getSecondaryTeamIds()
    {
        return $this->container['secondary_team_ids'];
    }

    /**
     * Sets secondary_team_ids
     *
     * @param string[]|null $secondary_team_ids The user's additional teams
     *
     * @return self
     */
    public function setSecondaryTeamIds($secondary_team_ids)
    {
        if (is_null($secondary_team_ids)) {
            throw new \InvalidArgumentException('non-nullable secondary_team_ids cannot be null');
        }
        $this->container['secondary_team_ids'] = $secondary_team_ids;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id The user's unique ID
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets super_admin
     *
     * @return bool|null
     */
    public function getSuperAdmin()
    {
        return $this->container['super_admin'];
    }

    /**
     * Sets super_admin
     *
     * @param bool|null $super_admin super_admin
     *
     * @return self
     */
    public function setSuperAdmin($super_admin)
    {
        if (is_null($super_admin)) {
            throw new \InvalidArgumentException('non-nullable super_admin cannot be null');
        }
        $this->container['super_admin'] = $super_admin;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string $email The user's email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


